/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.integration;

import fr.skynex.myEconomy.EconomyManager;
import fr.skynex.myEconomy.MyEconomy;
import fr.skynex.mycore.api.economy.EconomyProvider;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class MyEconomyProvider
implements EconomyProvider {
    private final MyEconomy plugin;
    private final EconomyManager economyManager;

    public MyEconomyProvider(MyEconomy plugin) {
        this.plugin = plugin;
        this.economyManager = plugin.getEconomyManager();
    }

    public String getProviderName() {
        return "MyEconomy";
    }

    public String getProviderVersion() {
        return this.plugin.getPluginMeta().getVersion();
    }

    public boolean isEnabled() {
        return this.plugin.isEnabled();
    }

    public double getBalance(Player player) {
        return this.economyManager.getBalance(player);
    }

    public double getBalance(UUID uuid) {
        return this.economyManager.getBalance(uuid);
    }

    public double getBalance(OfflinePlayer player) {
        return this.economyManager.getBalance(player.getUniqueId());
    }

    public boolean hasBalance(Player player, double amount) {
        return this.economyManager.hasBalance(player, amount);
    }

    public boolean hasBalance(UUID uuid, double amount) {
        return this.economyManager.hasBalance(uuid, amount);
    }

    public boolean deposit(Player player, double amount) {
        if (amount <= 0.0) {
            return false;
        }
        this.economyManager.addBalance(player, amount);
        return true;
    }

    public boolean deposit(UUID uuid, double amount) {
        if (amount <= 0.0) {
            return false;
        }
        this.economyManager.addBalance(uuid, amount);
        return true;
    }

    public boolean withdraw(Player player, double amount) {
        return this.economyManager.removeBalance(player, amount);
    }

    public boolean withdraw(UUID uuid, double amount) {
        return this.economyManager.removeBalance(uuid, amount);
    }

    public boolean setBalance(UUID uuid, double amount) {
        this.economyManager.setBalance(uuid, amount);
        return true;
    }

    public boolean transfer(Player from, Player to, double amount) {
        return this.economyManager.transfer(from, to, amount);
    }

    public boolean transfer(UUID from, UUID to, double amount) {
        return this.economyManager.transfer(from, to, amount);
    }

    public String getCurrencySingular() {
        return this.plugin.getConfigManager().getCurrencySingular();
    }

    public String getCurrencyPlural() {
        return this.plugin.getConfigManager().getCurrencyPlural();
    }

    public String getCurrencySymbol() {
        return this.plugin.getConfigManager().getCurrencySymbol();
    }

    public String format(double amount) {
        String currency = amount <= 1.0 ? this.getCurrencySingular() : this.getCurrencyPlural();
        return String.format("%.2f %s", amount, currency);
    }

    public Map<UUID, Double> getTopBalances(int limit) {
        return this.economyManager.getTopBalances(limit);
    }

    public int getPlayerRank(UUID uuid) {
        Map<UUID, Double> top = this.economyManager.getTopBalances(1000);
        int rank = 1;
        for (UUID topUuid : top.keySet()) {
            if (topUuid.equals(uuid)) {
                return rank;
            }
            ++rank;
        }
        return -1;
    }
}

