/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.integration;

import fr.skynex.myEconomy.MyEconomy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DynamicPricingSystem {
    private final MyEconomy plugin;
    private final Map<Material, Integer> itemSupplyCache;
    private final Map<Material, Double> basePrices;
    private final Map<Material, Double> rarePrices;

    public DynamicPricingSystem(MyEconomy plugin) {
        this.plugin = plugin;
        this.itemSupplyCache = new ConcurrentHashMap<Material, Integer>();
        this.basePrices = new HashMap<Material, Double>();
        this.rarePrices = new HashMap<Material, Double>();
        this.initializeDefaultPrices();
        this.startCacheUpdateTask();
    }

    private void initializeDefaultPrices() {
        this.basePrices.put(Material.OAK_LOG, 3.0);
        this.basePrices.put(Material.BIRCH_LOG, 3.0);
        this.basePrices.put(Material.SPRUCE_LOG, 3.0);
        this.basePrices.put(Material.JUNGLE_LOG, 3.0);
        this.basePrices.put(Material.ACACIA_LOG, 3.0);
        this.basePrices.put(Material.DARK_OAK_LOG, 3.0);
        this.basePrices.put(Material.COBBLESTONE, 2.0);
        this.basePrices.put(Material.STONE, 2.5);
        this.basePrices.put(Material.IRON_INGOT, 10.0);
        this.basePrices.put(Material.GOLD_INGOT, 15.0);
        this.basePrices.put(Material.DIAMOND, 50.0);
        this.basePrices.put(Material.EMERALD, 30.0);
        this.basePrices.put(Material.COAL, 1.5);
        this.basePrices.put(Material.WHEAT, 1.0);
        this.basePrices.put(Material.CARROT, 1.0);
        this.basePrices.put(Material.POTATO, 1.0);
        this.rarePrices.put(Material.OAK_LOG, 40.0);
        this.rarePrices.put(Material.BIRCH_LOG, 40.0);
        this.rarePrices.put(Material.SPRUCE_LOG, 40.0);
        this.rarePrices.put(Material.JUNGLE_LOG, 40.0);
        this.rarePrices.put(Material.ACACIA_LOG, 40.0);
        this.rarePrices.put(Material.DARK_OAK_LOG, 40.0);
        this.rarePrices.put(Material.COBBLESTONE, 30.0);
        this.rarePrices.put(Material.STONE, 35.0);
        this.rarePrices.put(Material.IRON_INGOT, 100.0);
        this.rarePrices.put(Material.GOLD_INGOT, 150.0);
        this.rarePrices.put(Material.DIAMOND, 500.0);
        this.rarePrices.put(Material.EMERALD, 300.0);
        this.rarePrices.put(Material.COAL, 20.0);
        this.rarePrices.put(Material.WHEAT, 15.0);
        this.rarePrices.put(Material.CARROT, 15.0);
        this.rarePrices.put(Material.POTATO, 15.0);
    }

    public void updateSupplyCache(Map<Material, Integer> supplyData) {
        this.itemSupplyCache.clear();
        this.itemSupplyCache.putAll(supplyData);
    }

    public void resetCache() {
        this.itemSupplyCache.clear();
    }

    public void registerItemForSale(ItemStack item, int stackCount) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        Material material = item.getType();
        this.itemSupplyCache.put(material, this.itemSupplyCache.getOrDefault(material, 0) + stackCount);
    }

    public void scanInventory(Inventory inventory) {
        this.resetCache();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            int stackCount = (int)Math.ceil((double)item.getAmount() / 64.0);
            if (stackCount == 0) {
                stackCount = 1;
            }
            this.registerItemForSale(item, stackCount);
        }
    }

    public void removeItemFromSale(ItemStack item, int stackCount) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        Material material = item.getType();
        int current = this.itemSupplyCache.getOrDefault(material, 0);
        int newValue = Math.max(0, current - stackCount);
        if (newValue == 0) {
            this.itemSupplyCache.remove(material);
        } else {
            this.itemSupplyCache.put(material, newValue);
        }
    }

    public double calculateSuggestedPrice(ItemStack item, int stackCount) {
        double suggestedPrice;
        double marketPrice;
        if (item == null || item.getType() == Material.AIR) {
            return 0.0;
        }
        Material material = item.getType();
        int totalSupply = this.itemSupplyCache.getOrDefault(material, 0);
        if (this.plugin.getMarketIntelligence() != null && this.plugin.getConfigManager().isMarketLearningEnabled() && (marketPrice = this.plugin.getMarketIntelligence().getPricePerItem(material)) > 0.0) {
            double marketPricePerStack = marketPrice * 64.0;
            int highSupplyThreshold = this.plugin.getConfigManager().getAuctionHouseHighSupplyThreshold();
            int lowSupplyThreshold = this.plugin.getConfigManager().getAuctionHouseLowSupplyThreshold();
            if (totalSupply >= highSupplyThreshold) {
                return marketPricePerStack * 0.8;
            }
            if (totalSupply <= lowSupplyThreshold) {
                return marketPricePerStack * 1.3;
            }
            return marketPricePerStack;
        }
        double basePrice = this.basePrices.getOrDefault(material, 5.0);
        double rarePrice = this.rarePrices.getOrDefault(material, 50.0);
        int highSupplyThreshold = this.plugin.getConfigManager().getAuctionHouseHighSupplyThreshold();
        int lowSupplyThreshold = this.plugin.getConfigManager().getAuctionHouseLowSupplyThreshold();
        if (totalSupply >= highSupplyThreshold) {
            suggestedPrice = basePrice;
        } else if (totalSupply <= lowSupplyThreshold) {
            suggestedPrice = rarePrice;
        } else {
            double ratio = (double)(totalSupply - lowSupplyThreshold) / (double)(highSupplyThreshold - lowSupplyThreshold);
            suggestedPrice = rarePrice - (rarePrice - basePrice) * ratio;
        }
        return suggestedPrice;
    }

    public PriceValidationResult validatePrice(ItemStack item, double proposedPrice, int stackCount) {
        if (item == null || item.getType() == Material.AIR) {
            return new PriceValidationResult(false, 0.0, 0.0, "Invalid item");
        }
        double suggestedPrice = this.calculateSuggestedPrice(item, stackCount);
        double maxAcceptablePrice = suggestedPrice * this.plugin.getConfigManager().getAuctionHouseMaxPriceMultiplier();
        boolean isAcceptable = proposedPrice <= maxAcceptablePrice;
        String reason = isAcceptable ? "Acceptable price" : String.format("Price too high. Suggested price: %.2f (supply: %d stacks)", suggestedPrice, this.itemSupplyCache.getOrDefault(item.getType(), 0));
        return new PriceValidationResult(isAcceptable, suggestedPrice, maxAcceptablePrice, reason);
    }

    public int getSupplyCount(Material material) {
        return this.itemSupplyCache.getOrDefault(material, 0);
    }

    public Map<Material, Integer> getAllSupplyData() {
        return new HashMap<Material, Integer>(this.itemSupplyCache);
    }

    private void startCacheUpdateTask() {
        if (!this.plugin.getConfigManager().isAuctionHouseEnabled()) {
            return;
        }
        int updateInterval = this.plugin.getConfigManager().getAuctionHousePriceUpdateInterval();
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> this.cleanupCache(), 0L, 1200L * (long)updateInterval);
    }

    private void cleanupCache() {
        this.itemSupplyCache.entrySet().removeIf(entry -> (Integer)entry.getValue() <= 0);
    }

    public double getBasePrice(Material material) {
        return this.basePrices.getOrDefault(material, 0.0);
    }

    public static class PriceValidationResult {
        private final boolean acceptable;
        private final double suggestedPrice;
        private final double maxPrice;
        private final String reason;

        public PriceValidationResult(boolean acceptable, double suggestedPrice, double maxPrice, String reason) {
            this.acceptable = acceptable;
            this.suggestedPrice = suggestedPrice;
            this.maxPrice = maxPrice;
            this.reason = reason;
        }

        public boolean isAcceptable() {
            return this.acceptable;
        }

        public double getSuggestedPrice() {
            return this.suggestedPrice;
        }

        public double getMaxPrice() {
            return this.maxPrice;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

