/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.database;

import fr.skynex.myEconomy.MyEconomy;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseManager {
    private final MyEconomy plugin;
    private Connection connection;

    public DatabaseManager(MyEconomy plugin) {
        this.plugin = plugin;
    }

    public boolean isMySQLAvailable() {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean isSQLiteAvailable() {
        try {
            Class.forName("org.sqlite.JDBC");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void connect() {
        String dbType = this.plugin.getConfigManager().getDatabaseType().toLowerCase();
        if (dbType.equals("sqlite")) {
            this.connectSQLite();
        } else if (dbType.equals("mysql")) {
            this.connectMySQL();
        }
    }

    private void connectSQLite() {
        try {
            if (!this.isSQLiteAvailable()) {
                this.plugin.getLogger().warning("SQLite driver not available! Use a Paper server for built-in SQLite support.");
                return;
            }
            File dbFile = new File(this.plugin.getDataFolder(), this.plugin.getConfigManager().getSQLitePath());
            String url = "jdbc:sqlite:" + dbFile.getAbsolutePath();
            this.connection = DriverManager.getConnection(url);
            this.createTablesSQLite();
            this.plugin.getLogger().info("SQLite connection established!");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error during SQLite connection: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void connectMySQL() {
        try {
            if (!this.isMySQLAvailable()) {
                this.plugin.getLogger().warning("MySQL Connector not found! Ensure Paper loaded the library (check internet on first run).");
                return;
            }
            String host = this.plugin.getConfigManager().getMySQLHost();
            int port = this.plugin.getConfigManager().getMySQLPort();
            String database = this.plugin.getConfigManager().getMySQLDatabase();
            String username = this.plugin.getConfigManager().getMySQLUsername();
            String password = this.plugin.getConfigManager().getMySQLPassword();
            boolean useSSL = this.plugin.getConfigManager().getMySQLUseSSL();
            String url = "jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=" + useSSL;
            this.connection = DriverManager.getConnection(url, username, password);
            this.createTables();
            this.plugin.getLogger().info("MySQL connection established successfully!");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error during MySQL connection: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.plugin.getLogger().info("MySQL connection closed.");
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error closing MySQL connection: " + e.getMessage());
            }
        }
    }

    private void createTables() throws SQLException {
        String balancesTable = "CREATE TABLE IF NOT EXISTS balances (uuid VARCHAR(36) PRIMARY KEY, balance DOUBLE NOT NULL DEFAULT 0.0)";
        String statsTable = "CREATE TABLE IF NOT EXISTS stats (uuid VARCHAR(36) PRIMARY KEY, total_earned DOUBLE NOT NULL DEFAULT 0.0, total_spent DOUBLE NOT NULL DEFAULT 0.0, transactions_count INT NOT NULL DEFAULT 0)";
        String transactionsTable = "CREATE TABLE IF NOT EXISTS transactions (id INT AUTO_INCREMENT PRIMARY KEY, from_uuid VARCHAR(36), to_uuid VARCHAR(36), amount DOUBLE NOT NULL, type VARCHAR(20) NOT NULL, timestamp BIGINT NOT NULL)";
        String weeklyRankingsTable = "CREATE TABLE IF NOT EXISTS weekly_rankings (uuid VARCHAR(36) PRIMARY KEY, balance DOUBLE NOT NULL DEFAULT 0.0, week_start BIGINT NOT NULL)";
        String monthlyRankingsTable = "CREATE TABLE IF NOT EXISTS monthly_rankings (uuid VARCHAR(36) PRIMARY KEY, balance DOUBLE NOT NULL DEFAULT 0.0, month_start BIGINT NOT NULL)";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(balancesTable);
            stmt.execute(statsTable);
            stmt.execute(transactionsTable);
            stmt.execute(weeklyRankingsTable);
            stmt.execute(monthlyRankingsTable);
        }
    }

    private void createTablesSQLite() throws SQLException {
        String balancesTable = "CREATE TABLE IF NOT EXISTS balances (uuid TEXT PRIMARY KEY, balance REAL NOT NULL DEFAULT 0.0)";
        String statsTable = "CREATE TABLE IF NOT EXISTS stats (uuid TEXT PRIMARY KEY, total_earned REAL NOT NULL DEFAULT 0.0, total_spent REAL NOT NULL DEFAULT 0.0, transactions_count INTEGER NOT NULL DEFAULT 0)";
        String transactionsTable = "CREATE TABLE IF NOT EXISTS transactions (id INTEGER PRIMARY KEY AUTOINCREMENT, from_uuid TEXT, to_uuid TEXT, amount REAL NOT NULL, type TEXT NOT NULL, timestamp INTEGER NOT NULL)";
        String weeklyRankingsTable = "CREATE TABLE IF NOT EXISTS weekly_rankings (uuid TEXT PRIMARY KEY, balance REAL NOT NULL DEFAULT 0.0, week_start INTEGER NOT NULL)";
        String monthlyRankingsTable = "CREATE TABLE IF NOT EXISTS monthly_rankings (uuid TEXT PRIMARY KEY, balance REAL NOT NULL DEFAULT 0.0, month_start INTEGER NOT NULL)";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(balancesTable);
            stmt.execute(statsTable);
            stmt.execute(transactionsTable);
            stmt.execute(weeklyRankingsTable);
            stmt.execute(monthlyRankingsTable);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isConnected() {
        try {
            return this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }
}

