/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.commands;

import fr.skynex.myEconomy.EconomyManager;
import fr.skynex.myEconomy.MyEconomy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class BalanceCommand
implements CommandExecutor,
TabCompleter {
    private final EconomyManager economyManager;
    private final MyEconomy plugin;

    public BalanceCommand(EconomyManager economyManager) {
        this.economyManager = economyManager;
        this.plugin = MyEconomy.getInstance();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("myeconomy.balance")) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-no-permission"));
            return true;
        }
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-player-only"));
                return true;
            }
            Player player = (Player)sender;
            double balance = this.economyManager.getBalance(player);
            String currency = balance <= 1.0 ? this.plugin.getConfigManager().getCurrencySingular() : this.plugin.getConfigManager().getCurrencyPlural();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("prefix", this.plugin.getLanguageManager().getMessage("prefix"));
            placeholders.put("balance", String.format("%.2f", balance));
            placeholders.put("coins", currency);
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("balance-own", placeholders));
            return true;
        }
        if (!sender.hasPermission("myeconomy.balance.others")) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-no-permission"));
            return true;
        }
        OfflinePlayer target = this.plugin.getServer().getOfflinePlayer(args[0]);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
            errorPlaceholders.put("player", args[0]);
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-player-not-found", errorPlaceholders));
            return true;
        }
        double balance = this.economyManager.getBalance(target.getUniqueId());
        String currency = balance <= 1.0 ? this.plugin.getConfigManager().getCurrencySingular() : this.plugin.getConfigManager().getCurrencyPlural();
        String targetName = target.getName() != null ? target.getName() : args[0];
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("prefix", this.plugin.getLanguageManager().getMessage("prefix"));
        placeholders.put("player", targetName);
        placeholders.put("balance", String.format("%.2f", balance));
        placeholders.put("coins", currency);
        sender.sendMessage(this.plugin.getLanguageManager().getMessage("balance-other", placeholders));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1 && sender.hasPermission("myeconomy.balance.others")) {
            ArrayList<String> completions = new ArrayList<String>();
            String input = args[0].toLowerCase();
            for (OfflinePlayer op : MyEconomy.getInstance().getServer().getOfflinePlayers()) {
                String name = op.getName();
                if (name == null || !name.toLowerCase().startsWith(input)) continue;
                completions.add(name);
            }
            return completions;
        }
        return new ArrayList<String>();
    }
}

