/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.api;

import fr.skynex.myEconomy.MyEconomy;
import fr.skynex.myEconomy.integration.DynamicPricingSystem;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MyEconomyAPI {
    private static MyEconomyAPI instance;
    private final MyEconomy plugin;

    private MyEconomyAPI(MyEconomy plugin) {
        this.plugin = plugin;
    }

    public static MyEconomyAPI getInstance() {
        if (instance == null && MyEconomy.getInstance() != null) {
            instance = new MyEconomyAPI(MyEconomy.getInstance());
        }
        return instance;
    }

    public double getBalance(UUID playerId) {
        return this.plugin.getEconomyManager().getBalance(playerId);
    }

    public double getBalance(Player player) {
        return this.getBalance(player.getUniqueId());
    }

    public void setBalance(UUID playerId, double amount) {
        this.plugin.getEconomyManager().setBalance(playerId, amount);
    }

    public void setBalance(Player player, double amount) {
        this.setBalance(player.getUniqueId(), amount);
    }

    public void addBalance(UUID playerId, double amount) {
        this.plugin.getEconomyManager().addBalance(playerId, amount);
        this.plugin.getStatsManager().recordTransaction(playerId, amount, "earned");
    }

    public void addBalance(Player player, double amount) {
        this.addBalance(player.getUniqueId(), amount);
    }

    public boolean removeBalance(UUID playerId, double amount) {
        boolean success = this.plugin.getEconomyManager().removeBalance(playerId, amount);
        if (success) {
            this.plugin.getStatsManager().recordTransaction(playerId, amount, "spent");
        }
        return success;
    }

    public boolean removeBalance(Player player, double amount) {
        return this.removeBalance(player.getUniqueId(), amount);
    }

    public boolean hasBalance(UUID playerId, double amount) {
        return this.plugin.getEconomyManager().hasBalance(playerId, amount);
    }

    public boolean hasBalance(Player player, double amount) {
        return this.hasBalance(player.getUniqueId(), amount);
    }

    public boolean transfer(UUID from, UUID to, double amount) {
        boolean success = this.plugin.getEconomyManager().transfer(from, to, amount);
        if (success) {
            this.plugin.getStatsManager().recordTransaction(from, amount, "sent");
            this.plugin.getStatsManager().recordTransaction(to, amount, "received");
        }
        return success;
    }

    public boolean transfer(Player from, Player to, double amount) {
        return this.transfer(from.getUniqueId(), to.getUniqueId(), amount);
    }

    public String getCurrencyName() {
        return this.plugin.getConfigManager().getCurrencyName();
    }

    public String format(double amount) {
        String currency = amount <= 1.0 ? this.plugin.getConfigManager().getCurrencySingular() : this.plugin.getConfigManager().getCurrencyPlural();
        return String.format("%.2f %s", amount, currency);
    }

    public void logTransaction(String type, UUID playerId, UUID targetId, double amount, String details) {
        this.plugin.getAuditLogger().logTransaction(type, playerId, targetId, amount, details);
    }

    public double getSuggestedAuctionPrice(ItemStack item, int stackCount) {
        if (this.plugin.getAuctionHouseIntegration() == null || this.plugin.getAuctionHouseIntegration().getDynamicPricing() == null) {
            return 0.0;
        }
        return this.plugin.getAuctionHouseIntegration().getDynamicPricing().calculateSuggestedPrice(item, stackCount);
    }

    public DynamicPricingSystem.PriceValidationResult validateAuctionPrice(ItemStack item, double proposedPrice, int stackCount) {
        if (this.plugin.getAuctionHouseIntegration() == null || this.plugin.getAuctionHouseIntegration().getDynamicPricing() == null) {
            return new DynamicPricingSystem.PriceValidationResult(true, 0.0, Double.MAX_VALUE, "Dynamic pricing system disabled");
        }
        return this.plugin.getAuctionHouseIntegration().getDynamicPricing().validatePrice(item, proposedPrice, stackCount);
    }

    public void registerAuctionItem(ItemStack item, int stackCount) {
        if (this.plugin.getAuctionHouseIntegration() != null) {
            this.plugin.getAuctionHouseIntegration().registerItemForSale(item, stackCount);
        }
    }

    public void removeAuctionItem(ItemStack item, int stackCount) {
        if (this.plugin.getAuctionHouseIntegration() != null) {
            this.plugin.getAuctionHouseIntegration().removeItemFromSale(item, stackCount);
        }
    }

    public double getMarketPrice(Material material) {
        if (this.plugin.getMarketIntelligence() == null) {
            return 0.0;
        }
        return this.plugin.getMarketIntelligence().getPricePerItem(material);
    }
}

