/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy;

import fr.skynex.myEconomy.MyEconomy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class SecurityManager {
    private final MyEconomy plugin;
    private final Map<UUID, List<Long>> transactionTimestamps;
    private final Map<UUID, Long> lastTransactionTime;
    private final Map<UUID, PendingTransaction> pendingConfirmations;
    private static final long CONFIRMATION_EXPIRY_MS = 60000L;

    public SecurityManager(MyEconomy plugin) {
        this.plugin = plugin;
        this.transactionTimestamps = new ConcurrentHashMap<UUID, List<Long>>();
        this.lastTransactionTime = new ConcurrentHashMap<UUID, Long>();
        this.pendingConfirmations = new ConcurrentHashMap<UUID, PendingTransaction>();
    }

    public boolean canMakeTransaction(Player player) {
        int cooldown;
        long lastTime;
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        if (this.lastTransactionTime.containsKey(uuid) && now - (lastTime = this.lastTransactionTime.get(uuid).longValue()) < (long)(cooldown = this.plugin.getConfigManager().getTransactionCooldown() * 1000)) {
            this.plugin.getAuditLogger().logSuspiciousActivity(uuid, "TRANSACTION_COOLDOWN_VIOLATION", "Transaction attempt too fast");
            return false;
        }
        List timestamps = this.transactionTimestamps.getOrDefault(uuid, new ArrayList());
        long oneMinuteAgo = now - 60000L;
        timestamps.removeIf(time -> time < oneMinuteAgo);
        int maxTransactions = this.plugin.getConfigManager().getMaxTransactionsPerMinute();
        if (timestamps.size() >= maxTransactions) {
            this.plugin.getAuditLogger().logSuspiciousActivity(uuid, "TRANSACTION_LIMIT_EXCEEDED", "Too many transactions in one minute: " + timestamps.size());
            return false;
        }
        return true;
    }

    public void recordTransaction(Player player) {
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        this.transactionTimestamps.computeIfAbsent(uuid, k -> new ArrayList()).add(now);
        this.lastTransactionTime.put(uuid, now);
    }

    public boolean requiresConfirmation(double amount) {
        return amount >= this.plugin.getConfigManager().getPayConfirmationThreshold();
    }

    public void addPendingConfirmation(Player player, PendingTransaction transaction) {
        this.pendingConfirmations.put(player.getUniqueId(), transaction);
    }

    public PendingTransaction getPendingConfirmation(Player player) {
        PendingTransaction pending = this.pendingConfirmations.remove(player.getUniqueId());
        if (pending != null && pending.isExpired()) {
            this.plugin.getAuditLogger().logSuspiciousActivity(player.getUniqueId(), "CONFIRMATION_EXPIRED", "Transaction confirmation expired");
            return null;
        }
        return pending;
    }

    public void clearPendingConfirmation(Player player) {
        this.pendingConfirmations.remove(player.getUniqueId());
    }

    public void cleanupExpiredConfirmations() {
        this.pendingConfirmations.entrySet().removeIf(entry -> ((PendingTransaction)entry.getValue()).isExpired());
    }

    public static class PendingTransaction {
        private final UUID target;
        private final double amount;
        private final long createdAt;

        public PendingTransaction(UUID target, double amount) {
            this.target = target;
            this.amount = amount;
            this.createdAt = System.currentTimeMillis();
        }

        public UUID getTarget() {
            return this.target;
        }

        public double getAmount() {
            return this.amount;
        }

        public long getCreatedAt() {
            return this.createdAt;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.createdAt > 60000L;
        }
    }
}

