/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy;

import fr.skynex.myEconomy.MyEconomy;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageManager {
    private final MyEconomy plugin;
    private final Map<String, FileConfiguration> languages;
    private String currentLanguage;

    public LanguageManager(MyEconomy plugin) {
        this.plugin = plugin;
        this.languages = new HashMap<String, FileConfiguration>();
        this.loadLanguages();
    }

    private void loadLanguages() {
        String[] availableLanguages;
        this.currentLanguage = this.plugin.getConfigManager().getLanguage();
        File languagesFolder = new File(this.plugin.getDataFolder(), "languages");
        if (!languagesFolder.exists()) {
            languagesFolder.mkdirs();
        }
        for (String lang : availableLanguages = new String[]{"en", "zh", "hi", "es", "fr", "ar", "pt", "ru", "ja", "de"}) {
            File langFile = new File(languagesFolder, "messages_" + lang + ".yml");
            if (!langFile.exists()) {
                try {
                    this.plugin.saveResource("languages/messages_" + lang + ".yml", false);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Unable to copy language file " + lang + ": " + e.getMessage());
                }
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)langFile);
            InputStream defaultStream = this.plugin.getResource("languages/messages_" + lang + ".yml");
            if (defaultStream != null) {
                try (InputStreamReader reader = new InputStreamReader(defaultStream, StandardCharsets.UTF_8);){
                    YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)reader);
                    config.setDefaults((Configuration)defaultConfig);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Unable to load default values for " + lang + ": " + e.getMessage());
                }
            }
            this.languages.put(lang, (FileConfiguration)config);
        }
        if (!this.languages.containsKey(this.currentLanguage)) {
            this.plugin.getLogger().warning("Language '" + this.currentLanguage + "' not found, using 'en' by default.");
            this.currentLanguage = "en";
        }
    }

    public String getMessage(String key) {
        return this.getMessage(key, this.currentLanguage);
    }

    public String getMessage(String key, String language) {
        String message;
        FileConfiguration config = this.languages.get(language);
        if (config == null) {
            config = this.languages.get("en");
        }
        if ((message = config.getString(key)) == null) {
            this.plugin.getLogger().warning("Missing message for key: " + key);
            return "\u00a7c[Missing message: " + key + "]";
        }
        return message.replace('&', '\u00a7');
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.getMessage(key);
        if (placeholders.isEmpty()) {
            return message;
        }
        StringBuilder result = new StringBuilder(message);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            String placeholder = "{" + entry.getKey() + "}";
            String value = entry.getValue();
            int index = 0;
            while ((index = result.indexOf(placeholder, index)) != -1) {
                result.replace(index, index + placeholder.length(), value);
                index += value.length();
            }
        }
        return result.toString();
    }

    public void reload() {
        this.languages.clear();
        this.loadLanguages();
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public void setLanguage(String language) {
        if (this.languages.containsKey(language)) {
            this.currentLanguage = language;
        } else {
            this.plugin.getLogger().warning("Language '" + language + "' not available.");
        }
    }
}

