/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.storage;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.libs.hikari.HikariConfig;
import fr.skynex.mycommands.libs.hikari.HikariDataSource;
import fr.skynex.mycommands.storage.StorageProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class MySQLStorage
implements StorageProvider {
    private final MyCommands plugin;
    private HikariDataSource dataSource;

    public MySQLStorage(MyCommands plugin) {
        this.plugin = plugin;
        this.initialize();
    }

    @Override
    public void initialize() {
        this.setupDataSource();
        this.createTables();
        this.plugin.getLogger().info("MySQL storage initialized with HikariCP");
    }

    private void setupDataSource() {
        HikariConfig config = new HikariConfig();
        String host = this.plugin.getConfig().getString("storage.mysql.host", "localhost");
        int port = this.plugin.getConfig().getInt("storage.mysql.port", 3306);
        String database = this.plugin.getConfig().getString("storage.mysql.database", "mycommands");
        String username = this.plugin.getConfig().getString("storage.mysql.username", "root");
        String password = this.plugin.getConfig().getString("storage.mysql.password", "");
        config.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=false&autoReconnect=true&characterEncoding=UTF-8");
        config.setUsername(username);
        config.setPassword(password);
        config.setMaximumPoolSize(this.plugin.getConfig().getInt("storage.mysql.pool.maximum-pool-size", 10));
        config.setMinimumIdle(this.plugin.getConfig().getInt("storage.mysql.pool.minimum-idle", 2));
        config.setMaxLifetime(this.plugin.getConfig().getLong("storage.mysql.pool.maximum-lifetime", 1800000L));
        config.setConnectionTimeout(this.plugin.getConfig().getLong("storage.mysql.pool.connection-timeout", 30000L));
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        this.dataSource = new HikariDataSource(config);
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    private void createTables() {
        try (Connection conn = this.getConnection();){
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS homes (id INT AUTO_INCREMENT PRIMARY KEY,uuid VARCHAR(36) NOT NULL,name VARCHAR(32) NOT NULL,world VARCHAR(64) NOT NULL,x DOUBLE NOT NULL,y DOUBLE NOT NULL,z DOUBLE NOT NULL,yaw FLOAT NOT NULL,pitch FLOAT NOT NULL,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,UNIQUE KEY unique_home (uuid, name)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS warps (id INT AUTO_INCREMENT PRIMARY KEY,name VARCHAR(32) NOT NULL UNIQUE,world VARCHAR(64) NOT NULL,x DOUBLE NOT NULL,y DOUBLE NOT NULL,z DOUBLE NOT NULL,yaw FLOAT NOT NULL,pitch FLOAT NOT NULL,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS spawn (id INT PRIMARY KEY DEFAULT 1,world VARCHAR(64) NOT NULL,x DOUBLE NOT NULL,y DOUBLE NOT NULL,z DOUBLE NOT NULL,yaw FLOAT NOT NULL,pitch FLOAT NOT NULL,updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS player_settings (uuid VARCHAR(36) PRIMARY KEY,vanished BOOLEAN DEFAULT FALSE,frozen BOOLEAN DEFAULT FALSE,socialspy BOOLEAN DEFAULT FALSE,godmode BOOLEAN DEFAULT FALSE,updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
            try {
                conn.createStatement().execute("ALTER TABLE player_settings ADD COLUMN godmode BOOLEAN DEFAULT FALSE");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS ignored_players (id INT AUTO_INCREMENT PRIMARY KEY,player_uuid VARCHAR(36) NOT NULL,ignored_uuid VARCHAR(36) NOT NULL,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,UNIQUE KEY unique_ignore (player_uuid, ignored_uuid)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS nicknames (uuid VARCHAR(36) PRIMARY KEY,nickname VARCHAR(64) NOT NULL,updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
            this.plugin.getLogger().info("MySQL tables created/verified");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to create MySQL tables: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Location getHome(UUID uuid, String homeName) {
        String sql = "SELECT world, x, y, z, yaw, pitch FROM homes WHERE uuid = ? AND name = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.setString(2, homeName);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                Location location = this.getLocationFromResultSet(rs);
                return location;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get home: " + e.getMessage());
        }
        return null;
    }

    @Override
    public void setHome(UUID uuid, String homeName, Location location) {
        String sql = "INSERT INTO homes (uuid, name, world, x, y, z, yaw, pitch) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE world = VALUES(world), x = VALUES(x), y = VALUES(y), z = VALUES(z), yaw = VALUES(yaw), pitch = VALUES(pitch)";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.setString(2, homeName);
            ps.setString(3, location.getWorld().getName());
            ps.setDouble(4, location.getX());
            ps.setDouble(5, location.getY());
            ps.setDouble(6, location.getZ());
            ps.setFloat(7, location.getYaw());
            ps.setFloat(8, location.getPitch());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to set home: " + e.getMessage());
        }
    }

    @Override
    public void deleteHome(UUID uuid, String homeName) {
        String sql = "DELETE FROM homes WHERE uuid = ? AND name = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.setString(2, homeName);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to delete home: " + e.getMessage());
        }
    }

    @Override
    public Map<String, Location> getAllHomes(UUID uuid) {
        HashMap<String, Location> homes = new HashMap<String, Location>();
        String sql = "SELECT name, world, x, y, z, yaw, pitch FROM homes WHERE uuid = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString("name");
                    Location loc = this.getLocationFromResultSet(rs);
                    if (loc == null) continue;
                    homes.put(name, loc);
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get all homes: " + e.getMessage());
        }
        return homes;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean homeExists(UUID uuid, String homeName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getHomesCount(UUID uuid) {
        String sql = "SELECT COUNT(*) as count FROM homes WHERE uuid = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt("count");
                return n;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to count homes: " + e.getMessage());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Location getWarp(String warpName) {
        String sql = "SELECT world, x, y, z, yaw, pitch FROM warps WHERE name = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, warpName);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                Location location = this.getLocationFromResultSet(rs);
                return location;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get warp: " + e.getMessage());
        }
        return null;
    }

    @Override
    public void setWarp(String warpName, Location location) {
        String sql = "INSERT INTO warps (name, world, x, y, z, yaw, pitch) VALUES (?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE world = VALUES(world), x = VALUES(x), y = VALUES(y), z = VALUES(z), yaw = VALUES(yaw), pitch = VALUES(pitch)";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, warpName);
            ps.setString(2, location.getWorld().getName());
            ps.setDouble(3, location.getX());
            ps.setDouble(4, location.getY());
            ps.setDouble(5, location.getZ());
            ps.setFloat(6, location.getYaw());
            ps.setFloat(7, location.getPitch());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to set warp: " + e.getMessage());
        }
    }

    @Override
    public void deleteWarp(String warpName) {
        String sql = "DELETE FROM warps WHERE name = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, warpName);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to delete warp: " + e.getMessage());
        }
    }

    @Override
    public Map<String, Location> getAllWarps() {
        HashMap<String, Location> warps = new HashMap<String, Location>();
        String sql = "SELECT name, world, x, y, z, yaw, pitch FROM warps";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String name = rs.getString("name");
                Location loc = this.getLocationFromResultSet(rs);
                if (loc == null) continue;
                warps.put(name, loc);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get all warps: " + e.getMessage());
        }
        return warps;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean warpExists(String warpName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Location getSpawn() {
        String sql = "SELECT world, x, y, z, yaw, pitch FROM spawn WHERE id = 1";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            if (!rs.next()) return null;
            Location location = this.getLocationFromResultSet(rs);
            return location;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get spawn: " + e.getMessage());
        }
        return null;
    }

    @Override
    public void setSpawn(Location location) {
        String sql = "INSERT INTO spawn (id, world, x, y, z, yaw, pitch) VALUES (1, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE world = VALUES(world), x = VALUES(x), y = VALUES(y), z = VALUES(z), yaw = VALUES(yaw), pitch = VALUES(pitch)";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, location.getWorld().getName());
            ps.setDouble(2, location.getX());
            ps.setDouble(3, location.getY());
            ps.setDouble(4, location.getZ());
            ps.setFloat(5, location.getYaw());
            ps.setFloat(6, location.getPitch());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to set spawn: " + e.getMessage());
        }
    }

    @Override
    public void setVanish(UUID uuid, boolean vanished) {
        String sql = "INSERT INTO player_settings (uuid, vanished) VALUES (?, ?) ON DUPLICATE KEY UPDATE vanished = VALUES(vanished)";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.setBoolean(2, vanished);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to set vanish: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isVanished(UUID uuid) {
        String sql = "SELECT vanished FROM player_settings WHERE uuid = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return false;
                boolean bl = rs.getBoolean("vanished");
                return bl;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to check vanish: " + e.getMessage());
        }
        return false;
    }

    @Override
    public void setFreeze(UUID uuid, boolean frozen) {
        String sql = "INSERT INTO player_settings (uuid, frozen) VALUES (?, ?) ON DUPLICATE KEY UPDATE frozen = VALUES(frozen)";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.setBoolean(2, frozen);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to set freeze: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFrozen(UUID uuid) {
        String sql = "SELECT frozen FROM player_settings WHERE uuid = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return false;
                boolean bl = rs.getBoolean("frozen");
                return bl;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to check freeze: " + e.getMessage());
        }
        return false;
    }

    @Override
    public void setGodMode(UUID uuid, boolean enabled) {
        String sql = "INSERT INTO player_settings (uuid, godmode) VALUES (?, ?) ON DUPLICATE KEY UPDATE godmode = VALUES(godmode)";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.setBoolean(2, enabled);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to set godmode: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasGodMode(UUID uuid) {
        String sql = "SELECT godmode FROM player_settings WHERE uuid = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return false;
                boolean bl = rs.getBoolean("godmode");
                return bl;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to check godmode: " + e.getMessage());
        }
        return false;
    }

    @Override
    public void setSocialSpy(UUID uuid, boolean enabled) {
        String sql = "INSERT INTO player_settings (uuid, socialspy) VALUES (?, ?) ON DUPLICATE KEY UPDATE socialspy = VALUES(socialspy)";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.setBoolean(2, enabled);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to set socialspy: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasSocialSpy(UUID uuid) {
        String sql = "SELECT socialspy FROM player_settings WHERE uuid = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return false;
                boolean bl = rs.getBoolean("socialspy");
                return bl;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to check socialspy: " + e.getMessage());
        }
        return false;
    }

    @Override
    public void addIgnore(UUID player, UUID target) {
        String sql = "INSERT IGNORE INTO ignored_players (player_uuid, ignored_uuid) VALUES (?, ?)";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, player.toString());
            ps.setString(2, target.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to add ignore: " + e.getMessage());
        }
    }

    @Override
    public void removeIgnore(UUID player, UUID target) {
        String sql = "DELETE FROM ignored_players WHERE player_uuid = ? AND ignored_uuid = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, player.toString());
            ps.setString(2, target.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to remove ignore: " + e.getMessage());
        }
    }

    @Override
    public Set<UUID> getIgnoredPlayers(UUID player) {
        HashSet<UUID> ignored = new HashSet<UUID>();
        String sql = "SELECT ignored_uuid FROM ignored_players WHERE player_uuid = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, player.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    try {
                        ignored.add(UUID.fromString(rs.getString("ignored_uuid")));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get ignored players: " + e.getMessage());
        }
        return ignored;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isIgnoring(UUID player, UUID target) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setNickname(UUID uuid, String nickname) {
        String sql = "INSERT INTO nicknames (uuid, nickname) VALUES (?, ?) ON DUPLICATE KEY UPDATE nickname = VALUES(nickname)";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.setString(2, nickname);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to set nickname: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getNickname(UUID uuid) {
        String sql = "SELECT nickname FROM nicknames WHERE uuid = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString("nickname");
                return string;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get nickname: " + e.getMessage());
        }
        return null;
    }

    @Override
    public void removeNickname(UUID uuid) {
        String sql = "DELETE FROM nicknames WHERE uuid = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to remove nickname: " + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean hasNickname(UUID uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Set<UUID> getAllPlayerUUIDs() {
        HashSet<UUID> uuids = new HashSet<UUID>();
        String sql = "SELECT DISTINCT uuid FROM homes UNION SELECT DISTINCT uuid FROM nicknames UNION SELECT DISTINCT uuid FROM player_settings";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                try {
                    uuids.add(UUID.fromString(rs.getString("uuid")));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get all player UUIDs: " + e.getMessage());
        }
        return uuids;
    }

    private Location getLocationFromResultSet(ResultSet rs) throws SQLException {
        String worldName = rs.getString("world");
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            this.plugin.getLogger().warning("World not found: " + worldName);
            return null;
        }
        double x = rs.getDouble("x");
        double y = rs.getDouble("y");
        double z = rs.getDouble("z");
        float yaw = rs.getFloat("yaw");
        float pitch = rs.getFloat("pitch");
        return new Location(world, x, y, z, yaw, pitch);
    }

    @Override
    public String getType() {
        return "mysql";
    }

    @Override
    public void close() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
            this.plugin.getLogger().info("MySQL connection pool closed");
        }
    }
}

