/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.managers;

import fr.skynex.mycommands.MyCommands;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SoundManager {
    private final MyCommands plugin;
    private boolean soundsEnabled;
    private float masterVolume;

    public SoundManager(MyCommands plugin) {
        this.plugin = plugin;
        this.soundsEnabled = plugin.getConfig().getBoolean("sounds.enabled", true);
        this.masterVolume = (float)plugin.getConfig().getDouble("sounds.master-volume", 1.0);
    }

    public void play(Player player, SoundType type) {
        if (!this.soundsEnabled || player == null) {
            return;
        }
        player.playSound(player.getLocation(), type.getSound(), type.getVolume() * this.masterVolume, type.getPitch());
    }

    public void play(Player player, Sound sound, float volume, float pitch) {
        if (!this.soundsEnabled || player == null) {
            return;
        }
        player.playSound(player.getLocation(), sound, volume * this.masterVolume, pitch);
    }

    public void playSuccess(Player player) {
        this.play(player, SoundType.SUCCESS);
    }

    public void playError(Player player) {
        this.play(player, SoundType.ERROR);
    }

    public void playWarning(Player player) {
        this.play(player, SoundType.WARNING);
    }

    public void playTeleport(Player player) {
        this.play(player, SoundType.TELEPORT);
    }

    public void playClick(Player player) {
        this.play(player, SoundType.CLICK);
    }

    public void playCooldownSequence(Player player, int seconds) {
        if (!this.soundsEnabled) {
            return;
        }
        int i = 1;
        while (i < seconds) {
            int tick = i++;
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (player.isOnline()) {
                    this.play(player, SoundType.COOLDOWN_TICK);
                }
            }, (long)tick * 20L);
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOnline()) {
                this.play(player, SoundType.COOLDOWN_READY);
            }
        }, (long)seconds * 20L);
    }

    public void setSoundsEnabled(boolean enabled) {
        this.soundsEnabled = enabled;
        this.plugin.getConfig().set("sounds.enabled", (Object)enabled);
        this.plugin.saveConfig();
    }

    public void setMasterVolume(float volume) {
        this.masterVolume = Math.max(0.0f, Math.min(1.0f, volume));
        this.plugin.getConfig().set("sounds.master-volume", (Object)Float.valueOf(this.masterVolume));
        this.plugin.saveConfig();
    }

    public boolean isSoundsEnabled() {
        return this.soundsEnabled;
    }

    public float getMasterVolume() {
        return this.masterVolume;
    }

    public void reload() {
        this.soundsEnabled = this.plugin.getConfig().getBoolean("sounds.enabled", true);
        this.masterVolume = (float)this.plugin.getConfig().getDouble("sounds.master-volume", 1.0);
    }

    public static enum SoundType {
        SUCCESS(Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.2f),
        HOME_SET(Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.5f),
        WARP_SET(Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.3f),
        TELEPORT(Sound.ENTITY_ENDERMAN_TELEPORT, 0.8f, 1.0f),
        TELEPORT_START(Sound.ENTITY_ENDERMAN_TELEPORT, 0.5f, 1.2f),
        TELEPORT_ARRIVE(Sound.ENTITY_PLAYER_LEVELUP, 0.3f, 1.5f),
        ERROR(Sound.ENTITY_VILLAGER_NO, 1.0f, 0.8f),
        WARNING(Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f),
        CANCEL(Sound.BLOCK_NOTE_BLOCK_BASS, 0.8f, 0.7f),
        GUI_OPEN(Sound.BLOCK_CHEST_OPEN, 0.5f, 1.0f),
        GUI_CLOSE(Sound.BLOCK_CHEST_CLOSE, 0.5f, 1.0f),
        CLICK(Sound.UI_BUTTON_CLICK, 0.5f, 1.0f),
        HOVER(Sound.UI_BUTTON_CLICK, 0.3f, 1.5f),
        DELETE(Sound.ENTITY_ITEM_BREAK, 1.0f, 0.8f),
        CONFIRM(Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.2f),
        COOLDOWN_TICK(Sound.BLOCK_NOTE_BLOCK_HAT, 0.3f, 1.0f),
        COOLDOWN_READY(Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.2f);

        private final Sound sound;
        private final float volume;
        private final float pitch;

        private SoundType(Sound sound, float volume, float pitch) {
            this.sound = sound;
            this.volume = volume;
            this.pitch = pitch;
        }

        public Sound getSound() {
            return this.sound;
        }

        public float getVolume() {
            return this.volume;
        }

        public float getPitch() {
            return this.pitch;
        }
    }
}

