/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.managers;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.managers.MessageManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class JailManager
implements Listener {
    private final MyCommands plugin;
    private final MessageManager msg;
    private final Map<UUID, JailData> jailedPlayers = new HashMap<UUID, JailData>();
    private final Map<String, Location> jails = new HashMap<String, Location>();
    private final Map<UUID, BukkitTask> releaseTasks = new HashMap<UUID, BukkitTask>();
    private File jailedPlayersFile;
    private FileConfiguration jailedPlayersConfig;

    public JailManager(MyCommands plugin) {
        this.plugin = plugin;
        this.msg = plugin.getMessageManager();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.loadJails();
        this.loadJailedPlayers();
    }

    private void loadJails() {
        if (!this.plugin.getConfig().contains("jails")) {
            return;
        }
        for (String jailName : this.plugin.getConfig().getConfigurationSection("jails").getKeys(false)) {
            String path = "jails." + jailName;
            Location loc = new Location(Bukkit.getWorld((String)this.plugin.getConfig().getString(path + ".world")), this.plugin.getConfig().getDouble(path + ".x"), this.plugin.getConfig().getDouble(path + ".y"), this.plugin.getConfig().getDouble(path + ".z"), (float)this.plugin.getConfig().getDouble(path + ".yaw", 0.0), (float)this.plugin.getConfig().getDouble(path + ".pitch", 0.0));
            if (loc.getWorld() == null) continue;
            this.jails.put(jailName, loc);
        }
        this.plugin.getLogger().info("Loaded " + this.jails.size() + " jail(s)");
    }

    private void loadJailedPlayers() {
        this.jailedPlayersFile = new File(this.plugin.getDataFolder(), "jailed_players.yml");
        if (!this.jailedPlayersFile.exists()) {
            try {
                this.jailedPlayersFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to create jailed_players.yml: " + e.getMessage());
            }
        }
        this.jailedPlayersConfig = YamlConfiguration.loadConfiguration((File)this.jailedPlayersFile);
        if (this.jailedPlayersConfig.contains("jailed")) {
            for (String uuidStr : this.jailedPlayersConfig.getConfigurationSection("jailed").getKeys(false)) {
                try {
                    long elapsed;
                    String worldName;
                    UUID uuid = UUID.fromString(uuidStr);
                    String path = "jailed." + uuidStr;
                    String jailName = this.jailedPlayersConfig.getString(path + ".jail");
                    String reason = this.jailedPlayersConfig.getString(path + ".reason", "");
                    long jailedAt = this.jailedPlayersConfig.getLong(path + ".jailed_at");
                    long duration = this.jailedPlayersConfig.getLong(path + ".duration");
                    Location previousLoc = null;
                    if (this.jailedPlayersConfig.contains(path + ".previous_location.world") && Bukkit.getWorld((String)(worldName = this.jailedPlayersConfig.getString(path + ".previous_location.world"))) != null) {
                        previousLoc = new Location(Bukkit.getWorld((String)worldName), this.jailedPlayersConfig.getDouble(path + ".previous_location.x"), this.jailedPlayersConfig.getDouble(path + ".previous_location.y"), this.jailedPlayersConfig.getDouble(path + ".previous_location.z"), (float)this.jailedPlayersConfig.getDouble(path + ".previous_location.yaw", 0.0), (float)this.jailedPlayersConfig.getDouble(path + ".previous_location.pitch", 0.0));
                    }
                    if (duration > 0L && (elapsed = (System.currentTimeMillis() - jailedAt) / 1000L) >= duration) continue;
                    JailData data = new JailData(jailName, previousLoc, reason, jailedAt, duration);
                    this.jailedPlayers.put(uuid, data);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error loading jailed player " + uuidStr + ": " + e.getMessage());
                }
            }
        }
        this.plugin.getLogger().info("Loaded " + this.jailedPlayers.size() + " jailed player(s)");
    }

    private void saveJailedPlayers() {
        this.jailedPlayersConfig = new YamlConfiguration();
        for (Map.Entry<UUID, JailData> entry : this.jailedPlayers.entrySet()) {
            String path = "jailed." + entry.getKey().toString();
            JailData data = entry.getValue();
            this.jailedPlayersConfig.set(path + ".jail", (Object)data.getJailName());
            this.jailedPlayersConfig.set(path + ".reason", (Object)data.getReason());
            this.jailedPlayersConfig.set(path + ".jailed_at", (Object)data.getJailedAt());
            this.jailedPlayersConfig.set(path + ".duration", (Object)data.getDurationSeconds());
            if (data.getPreviousLocation() == null || data.getPreviousLocation().getWorld() == null) continue;
            Location loc = data.getPreviousLocation();
            this.jailedPlayersConfig.set(path + ".previous_location.world", (Object)loc.getWorld().getName());
            this.jailedPlayersConfig.set(path + ".previous_location.x", (Object)loc.getX());
            this.jailedPlayersConfig.set(path + ".previous_location.y", (Object)loc.getY());
            this.jailedPlayersConfig.set(path + ".previous_location.z", (Object)loc.getZ());
            this.jailedPlayersConfig.set(path + ".previous_location.yaw", (Object)Float.valueOf(loc.getYaw()));
            this.jailedPlayersConfig.set(path + ".previous_location.pitch", (Object)Float.valueOf(loc.getPitch()));
        }
        try {
            this.jailedPlayersConfig.save(this.jailedPlayersFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save jailed_players.yml: " + e.getMessage());
        }
    }

    public void saveJails() {
        this.plugin.getConfig().set("jails", null);
        for (Map.Entry<String, Location> entry : this.jails.entrySet()) {
            String path = "jails." + entry.getKey();
            Location loc = entry.getValue();
            this.plugin.getConfig().set(path + ".world", (Object)loc.getWorld().getName());
            this.plugin.getConfig().set(path + ".x", (Object)loc.getX());
            this.plugin.getConfig().set(path + ".y", (Object)loc.getY());
            this.plugin.getConfig().set(path + ".z", (Object)loc.getZ());
            this.plugin.getConfig().set(path + ".yaw", (Object)Float.valueOf(loc.getYaw()));
            this.plugin.getConfig().set(path + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        }
        this.plugin.saveConfig();
    }

    public void jailPlayer(Player player, String jailName, long durationSeconds, String reason) {
        if (!this.jails.containsKey(jailName)) {
            return;
        }
        Location jailLocation = this.jails.get(jailName);
        Location previousLocation = player.getLocation();
        JailData data = new JailData(jailName, previousLocation, reason, System.currentTimeMillis(), durationSeconds);
        this.jailedPlayers.put(player.getUniqueId(), data);
        this.saveJailedPlayers();
        player.teleport(jailLocation);
        if (durationSeconds > 0L) {
            this.scheduleRelease(player.getUniqueId(), durationSeconds);
        }
    }

    private void scheduleRelease(UUID uuid, long secondsRemaining) {
        BukkitTask oldTask = this.releaseTasks.remove(uuid);
        if (oldTask != null && !oldTask.isCancelled()) {
            oldTask.cancel();
        }
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null && this.isJailed(uuid)) {
                this.releasePlayer(player, true);
            } else if (this.isJailed(uuid)) {
                this.jailedPlayers.remove(uuid);
                this.saveJailedPlayers();
            }
        }, secondsRemaining * 20L);
        this.releaseTasks.put(uuid, task);
    }

    public void releasePlayer(Player player, boolean autoRelease) {
        JailData data = this.jailedPlayers.remove(player.getUniqueId());
        if (data == null) {
            return;
        }
        this.saveJailedPlayers();
        BukkitTask task = this.releaseTasks.remove(player.getUniqueId());
        if (task != null && !task.isCancelled()) {
            task.cancel();
        }
        if (data.getPreviousLocation() != null && data.getPreviousLocation().getWorld() != null) {
            player.teleport(data.getPreviousLocation());
        } else {
            Location spawn = this.plugin.getDataManager().getSpawn();
            if (spawn != null) {
                player.teleport(spawn);
            }
        }
    }

    public boolean isJailed(UUID uuid) {
        return this.jailedPlayers.containsKey(uuid);
    }

    public JailData getJailData(UUID uuid) {
        return this.jailedPlayers.get(uuid);
    }

    public void createJail(String name, Location location) {
        this.jails.put(name, location);
        this.saveJails();
    }

    public void deleteJail(String name) {
        this.jails.remove(name);
        this.saveJails();
    }

    public Map<String, Location> getJails() {
        return new HashMap<String, Location>(this.jails);
    }

    public Map<UUID, JailData> getJailedPlayers() {
        return new HashMap<UUID, JailData>(this.jailedPlayers);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.isJailed(event.getPlayer().getUniqueId())) {
            return;
        }
        if (event.getFrom().getX() != event.getTo().getX() || event.getFrom().getY() != event.getTo().getY() || event.getFrom().getZ() != event.getTo().getZ()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!this.isJailed(event.getPlayer().getUniqueId())) {
            return;
        }
        String command = event.getMessage().toLowerCase().split(" ")[0];
        List allowedCommands = this.plugin.getConfig().getStringList("jail.allowed-commands");
        boolean allowed = false;
        for (String cmd : allowedCommands) {
            if (!command.equals("/" + cmd.toLowerCase())) continue;
            allowed = true;
            break;
        }
        if (!allowed) {
            event.setCancelled(true);
            this.msg.sendMessage((CommandSender)event.getPlayer(), "jail.cannot-use-commands");
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        BukkitTask task = this.releaseTasks.remove(uuid);
        if (task != null && !task.isCancelled()) {
            task.cancel();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.isJailed(uuid)) {
            Location jailLocation;
            JailData data = this.jailedPlayers.get(uuid);
            if (!data.isPermanent()) {
                long remaining = data.getRemainingSeconds();
                if (remaining <= 0L) {
                    this.releasePlayer(player, true);
                    return;
                }
                this.scheduleRelease(uuid, remaining);
            }
            if ((jailLocation = this.jails.get(data.getJailName())) != null) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    if (player.isOnline()) {
                        player.teleport(jailLocation);
                        this.msg.sendMessage((CommandSender)player, "jail.still-jailed");
                    }
                }, 1L);
            }
        }
    }

    public void shutdown() {
        for (BukkitTask task : this.releaseTasks.values()) {
            if (task.isCancelled()) continue;
            task.cancel();
        }
        this.releaseTasks.clear();
    }

    public static class JailData {
        private final String jailName;
        private final Location previousLocation;
        private final String reason;
        private final long jailedAt;
        private final long durationSeconds;

        public JailData(String jailName, Location previousLocation, String reason, long jailedAt, long durationSeconds) {
            this.jailName = jailName;
            this.previousLocation = previousLocation;
            this.reason = reason;
            this.jailedAt = jailedAt;
            this.durationSeconds = durationSeconds;
        }

        public String getJailName() {
            return this.jailName;
        }

        public Location getPreviousLocation() {
            return this.previousLocation;
        }

        public String getReason() {
            return this.reason;
        }

        public long getJailedAt() {
            return this.jailedAt;
        }

        public long getDurationSeconds() {
            return this.durationSeconds;
        }

        public long getRemainingSeconds() {
            if (this.durationSeconds == 0L) {
                return -1L;
            }
            long elapsed = (System.currentTimeMillis() - this.jailedAt) / 1000L;
            return Math.max(0L, this.durationSeconds - elapsed);
        }

        public boolean isPermanent() {
            return this.durationSeconds == 0L;
        }
    }
}

