/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.managers;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.storage.MySQLStorage;
import fr.skynex.mycommands.storage.StorageProvider;
import fr.skynex.mycommands.storage.YamlStorage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DataManager {
    private final MyCommands plugin;
    private StorageProvider storage;
    private final Map<UUID, Location> lastLocations = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, UUID> lastMessagers = new ConcurrentHashMap<UUID, UUID>();
    private final Map<UUID, Boolean> vanishedPlayers = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> frozenPlayers = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> godModePlayers = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> socialSpyEnabled = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, Set<UUID>> ignoredPlayers = new ConcurrentHashMap<UUID, Set<UUID>>();
    private final Map<UUID, String> nicknames = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Set<UUID>> tpaRequests = new ConcurrentHashMap<UUID, Set<UUID>>();

    public DataManager(MyCommands plugin) {
        this.plugin = plugin;
        this.initializeStorage();
    }

    private void initializeStorage() {
        String storageType = this.plugin.getConfig().getString("storage.type", "yaml");
        this.storage = storageType.equalsIgnoreCase("mysql") ? new MySQLStorage(this.plugin) : new YamlStorage(this.plugin);
    }

    public Location getHome(UUID uuid, String homeName) {
        return this.storage.getHome(uuid, homeName);
    }

    public void setHome(UUID uuid, String homeName, Location location) {
        this.storage.setHome(uuid, homeName, location);
    }

    public void deleteHome(UUID uuid, String homeName) {
        this.storage.deleteHome(uuid, homeName);
    }

    public Map<String, Location> getAllHomes(UUID uuid) {
        return this.storage.getAllHomes(uuid);
    }

    public Map<String, Location> getHomes(UUID uuid) {
        return this.getAllHomes(uuid);
    }

    public boolean homeExists(UUID uuid, String homeName) {
        return this.storage.homeExists(uuid, homeName);
    }

    public int getHomesCount(UUID uuid) {
        return this.storage.getHomesCount(uuid);
    }

    public Location getWarp(String warpName) {
        return this.storage.getWarp(warpName);
    }

    public void setWarp(String warpName, Location location) {
        this.storage.setWarp(warpName, location);
    }

    public void deleteWarp(String warpName) {
        this.storage.deleteWarp(warpName);
    }

    public Map<String, Location> getAllWarps() {
        return this.storage.getAllWarps();
    }

    public Map<String, Location> getWarps() {
        return this.getAllWarps();
    }

    public boolean warpExists(String warpName) {
        return this.storage.warpExists(warpName);
    }

    public Location getSpawn() {
        return this.storage.getSpawn();
    }

    public void setSpawn(Location location) {
        this.storage.setSpawn(location);
    }

    public Location getLastLocation(UUID uuid) {
        return this.lastLocations.get(uuid);
    }

    public void setLastLocation(UUID uuid, Location location) {
        if (location != null) {
            this.lastLocations.put(uuid, location.clone());
        }
    }

    public void saveLastLocation(Player player) {
        this.setLastLocation(player.getUniqueId(), player.getLocation());
    }

    public void createTpaRequest(UUID requester, UUID target) {
        this.tpaRequests.computeIfAbsent(target, k -> new LinkedHashSet()).add(requester);
    }

    public boolean hasTpaRequest(UUID requester, UUID target) {
        Set<UUID> requests = this.tpaRequests.get(target);
        return requests != null && requests.contains(requester);
    }

    public void removeTpaRequest(UUID requester, UUID target) {
        Set<UUID> requests = this.tpaRequests.get(target);
        if (requests != null) {
            requests.remove(requester);
            if (requests.isEmpty()) {
                this.tpaRequests.remove(target);
            }
        }
    }

    public UUID getLatestTpaRequest(UUID target) {
        Set<UUID> requests = this.tpaRequests.get(target);
        if (requests == null || requests.isEmpty()) {
            return null;
        }
        UUID last = null;
        Iterator<UUID> iterator = requests.iterator();
        while (iterator.hasNext()) {
            UUID uuid;
            last = uuid = iterator.next();
        }
        return last;
    }

    public Set<UUID> getAllTpaRequests(UUID target) {
        return this.tpaRequests.getOrDefault(target, new LinkedHashSet());
    }

    public void setLastMessager(UUID player, UUID messager) {
        this.lastMessagers.put(player, messager);
    }

    public UUID getLastMessager(UUID player) {
        return this.lastMessagers.get(player);
    }

    public boolean toggleIgnore(UUID player, UUID target) {
        Set ignored = this.ignoredPlayers.computeIfAbsent(player, k -> new HashSet());
        if (ignored.contains(target)) {
            ignored.remove(target);
            this.storage.removeIgnore(player, target);
            return false;
        }
        ignored.add(target);
        this.storage.addIgnore(player, target);
        return true;
    }

    public boolean isIgnoring(UUID player, UUID target) {
        Set<UUID> ignored = this.ignoredPlayers.get(player);
        return ignored != null && ignored.contains(target);
    }

    public Set<UUID> getIgnoredPlayers(UUID player) {
        return this.ignoredPlayers.getOrDefault(player, new HashSet());
    }

    public void loadIgnoredPlayers(UUID player) {
        Set<UUID> ignored = this.storage.getIgnoredPlayers(player);
        if (!ignored.isEmpty()) {
            this.ignoredPlayers.put(player, ignored);
        }
    }

    public boolean toggleVanish(UUID uuid) {
        boolean current = this.vanishedPlayers.getOrDefault(uuid, false);
        boolean newState = !current;
        this.vanishedPlayers.put(uuid, newState);
        this.storage.setVanish(uuid, newState);
        return newState;
    }

    public boolean isVanished(UUID uuid) {
        return this.vanishedPlayers.getOrDefault(uuid, false);
    }

    public void setVanish(UUID uuid, boolean vanished) {
        this.vanishedPlayers.put(uuid, vanished);
        this.storage.setVanish(uuid, vanished);
    }

    public void loadVanish(UUID uuid) {
        boolean vanished = this.storage.isVanished(uuid);
        if (vanished) {
            this.vanishedPlayers.put(uuid, true);
        }
    }

    public boolean toggleFreeze(UUID uuid) {
        boolean current = this.frozenPlayers.getOrDefault(uuid, false);
        boolean newState = !current;
        this.frozenPlayers.put(uuid, newState);
        this.storage.setFreeze(uuid, newState);
        return newState;
    }

    public boolean isFrozen(UUID uuid) {
        return this.frozenPlayers.getOrDefault(uuid, false);
    }

    public void setFreeze(UUID uuid, boolean frozen) {
        this.frozenPlayers.put(uuid, frozen);
        this.storage.setFreeze(uuid, frozen);
    }

    public boolean toggleGodMode(UUID uuid) {
        boolean current = this.godModePlayers.getOrDefault(uuid, false);
        boolean newState = !current;
        this.godModePlayers.put(uuid, newState);
        this.storage.setGodMode(uuid, newState);
        return newState;
    }

    public boolean hasGodMode(UUID uuid) {
        return this.godModePlayers.getOrDefault(uuid, false);
    }

    public void setGodMode(UUID uuid, boolean enabled) {
        this.godModePlayers.put(uuid, enabled);
        this.storage.setGodMode(uuid, enabled);
    }

    public void loadGodMode(UUID uuid) {
        boolean godMode = this.storage.hasGodMode(uuid);
        if (godMode) {
            this.godModePlayers.put(uuid, true);
        }
    }

    public boolean toggleSocialSpy(UUID uuid) {
        boolean current = this.socialSpyEnabled.getOrDefault(uuid, false);
        boolean newState = !current;
        this.socialSpyEnabled.put(uuid, newState);
        this.storage.setSocialSpy(uuid, newState);
        return newState;
    }

    public boolean hasSocialSpy(UUID uuid) {
        return this.socialSpyEnabled.getOrDefault(uuid, false);
    }

    public void setSocialSpy(UUID uuid, boolean enabled) {
        this.socialSpyEnabled.put(uuid, enabled);
        this.storage.setSocialSpy(uuid, enabled);
    }

    public void setNickname(UUID uuid, String nickname) {
        this.nicknames.put(uuid, nickname);
        this.storage.setNickname(uuid, nickname);
    }

    public String getNickname(UUID uuid) {
        return this.nicknames.get(uuid);
    }

    public Map<UUID, String> getAllNicknames() {
        return new HashMap<UUID, String>(this.nicknames);
    }

    public void removeNickname(UUID uuid) {
        this.nicknames.remove(uuid);
        this.storage.removeNickname(uuid);
    }

    public boolean hasNickname(UUID uuid) {
        return this.nicknames.containsKey(uuid);
    }

    public void loadNickname(UUID uuid) {
        String nickname = this.storage.getNickname(uuid);
        if (nickname != null) {
            this.nicknames.put(uuid, nickname);
        }
    }

    public void loadPlayerData(UUID uuid) {
        this.loadVanish(uuid);
        this.loadNickname(uuid);
        this.loadIgnoredPlayers(uuid);
        this.loadGodMode(uuid);
    }

    public void savePlayerData(UUID uuid) {
    }

    public void cleanupPlayerData(UUID uuid) {
        this.lastLocations.remove(uuid);
        this.lastMessagers.remove(uuid);
        this.tpaRequests.remove(uuid);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.plugin.getServer().getPlayer(uuid) == null) {
                this.vanishedPlayers.remove(uuid);
                this.frozenPlayers.remove(uuid);
                this.socialSpyEnabled.remove(uuid);
                this.ignoredPlayers.remove(uuid);
                this.nicknames.remove(uuid);
            }
        }, 6000L);
    }

    public void migrate(String from, String to) throws Exception {
        this.plugin.getLogger().info(String.format("Migration %s -> %s started...", from, to));
        StorageProvider fromStorage = from.equalsIgnoreCase("yaml") ? new YamlStorage(this.plugin) : new MySQLStorage(this.plugin);
        StorageProvider toStorage = to.equalsIgnoreCase("yaml") ? new YamlStorage(this.plugin) : new MySQLStorage(this.plugin);
        Location spawn = fromStorage.getSpawn();
        if (spawn != null) {
            toStorage.setSpawn(spawn);
            this.plugin.getLogger().info("\u2713 Spawn migrated");
        }
        Map<String, Location> warps = fromStorage.getAllWarps();
        for (Map.Entry<String, Location> entry : warps.entrySet()) {
            toStorage.setWarp(entry.getKey(), entry.getValue());
        }
        this.plugin.getLogger().info("\u2713 " + warps.size() + " warp(s) migrated");
        Set<UUID> allPlayers = fromStorage.getAllPlayerUUIDs();
        int homesCount = 0;
        int playersCount = 0;
        for (UUID uuid : allPlayers) {
            ++playersCount;
            Map<String, Location> homes = fromStorage.getAllHomes(uuid);
            for (Map.Entry<String, Location> entry : homes.entrySet()) {
                toStorage.setHome(uuid, entry.getKey(), entry.getValue());
                ++homesCount;
            }
            String nickname = fromStorage.getNickname(uuid);
            if (nickname != null) {
                toStorage.setNickname(uuid, nickname);
            }
            if (fromStorage.isVanished(uuid)) {
                toStorage.setVanish(uuid, true);
            }
            if (fromStorage.isFrozen(uuid)) {
                toStorage.setFreeze(uuid, true);
            }
            if (fromStorage.hasSocialSpy(uuid)) {
                toStorage.setSocialSpy(uuid, true);
            }
            if (fromStorage.hasGodMode(uuid)) {
                toStorage.setGodMode(uuid, true);
            }
            Set<UUID> ignored = fromStorage.getIgnoredPlayers(uuid);
            for (UUID ignoredUuid : ignored) {
                toStorage.addIgnore(uuid, ignoredUuid);
            }
        }
        this.plugin.getLogger().info("\u2713 " + homesCount + " home(s) migrated from " + playersCount + " player(s)");
        fromStorage.close();
        toStorage.close();
        this.plugin.getLogger().info("Migration completed successfully!");
    }

    public String getStorageType() {
        return this.storage.getType();
    }

    public StorageProvider getStorage() {
        return this.storage;
    }

    public void reload() {
        String newType = this.plugin.getConfig().getString("storage.type", "yaml");
        if (!newType.equalsIgnoreCase(this.storage.getType())) {
            this.plugin.getLogger().warning("Storage type changed! Consider migrating data.");
        }
        this.plugin.getLogger().info("DataManager reloaded");
    }

    public void shutdown() {
        this.plugin.getLogger().info("Saving cached data...");
        if (this.storage != null) {
            this.storage.close();
        }
        this.lastLocations.clear();
        this.lastMessagers.clear();
        this.vanishedPlayers.clear();
        this.frozenPlayers.clear();
        this.godModePlayers.clear();
        this.socialSpyEnabled.clear();
        this.ignoredPlayers.clear();
        this.nicknames.clear();
        this.tpaRequests.clear();
        this.plugin.getLogger().info("DataManager shutdown complete");
    }
}

