/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.integrations;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.managers.DataManager;
import fr.skynex.mycommands.managers.StatisticsManager;
import fr.skynex.mycore.api.player.PlayerProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class MyPlayerProvider
implements PlayerProvider {
    private final MyCommands plugin;
    private final DataManager dataManager;

    public MyPlayerProvider(MyCommands plugin) {
        this.plugin = plugin;
        this.dataManager = plugin.getDataManager();
    }

    public String getProviderName() {
        return "MyCommands";
    }

    public String getProviderVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean isEnabled() {
        return this.plugin.isEnabled();
    }

    public List<String> getHomeNames(UUID uuid) {
        Map<String, Location> homes = this.dataManager.getHomes(uuid);
        return new ArrayList<String>(homes.keySet());
    }

    public Optional<Location> getHome(UUID uuid, String homeName) {
        Location home = this.dataManager.getHome(uuid, homeName);
        return Optional.ofNullable(home);
    }

    public boolean hasHome(UUID uuid, String homeName) {
        return this.dataManager.homeExists(uuid, homeName);
    }

    public int getHomeCount(UUID uuid) {
        return this.dataManager.getHomesCount(uuid);
    }

    public int getMaxHomes(Player player) {
        if (player.hasPermission("mycommands.sethome.unlimited")) {
            return Integer.MAX_VALUE;
        }
        for (int i = 50; i >= 1; --i) {
            if (!player.hasPermission("mycommands.sethome." + i)) continue;
            return i;
        }
        return this.plugin.getConfig().getInt("limits.max-homes", 3);
    }

    public List<String> getWarpNames() {
        return new ArrayList<String>(this.dataManager.getAllWarps().keySet());
    }

    public Optional<Location> getWarp(String warpName) {
        Location warp = this.dataManager.getWarp(warpName);
        return Optional.ofNullable(warp);
    }

    public boolean warpExists(String warpName) {
        return this.dataManager.warpExists(warpName);
    }

    public Optional<Location> getSpawn() {
        Location spawn = this.dataManager.getSpawn();
        return Optional.ofNullable(spawn);
    }

    public boolean isSpawnSet() {
        return this.dataManager.getSpawn() != null;
    }

    public boolean isAFK(Player player) {
        return this.isAFK(player.getUniqueId());
    }

    public boolean isAFK(UUID uuid) {
        if (this.plugin.getAFKManager() == null) {
            return false;
        }
        return this.plugin.getAFKManager().isAFK(uuid);
    }

    public boolean isVanished(Player player) {
        return this.isVanished(player.getUniqueId());
    }

    public boolean isVanished(UUID uuid) {
        return this.dataManager.isVanished(uuid);
    }

    public boolean isFrozen(Player player) {
        return this.isFrozen(player.getUniqueId());
    }

    public boolean isFrozen(UUID uuid) {
        return this.dataManager.isFrozen(uuid);
    }

    public boolean isGodMode(Player player) {
        return this.isGodMode(player.getUniqueId());
    }

    public boolean isGodMode(UUID uuid) {
        return this.dataManager.hasGodMode(uuid);
    }

    public boolean isJailed(Player player) {
        return this.isJailed(player.getUniqueId());
    }

    public boolean isJailed(UUID uuid) {
        if (this.plugin.getJailManager() == null) {
            return false;
        }
        return this.plugin.getJailManager().isJailed(uuid);
    }

    public Optional<String> getNickname(UUID uuid) {
        String nick = this.dataManager.getNickname(uuid);
        return Optional.ofNullable(nick);
    }

    public boolean hasNickname(UUID uuid) {
        return this.dataManager.getNickname(uuid) != null;
    }

    public String getDisplayName(Player player) {
        String nick = this.dataManager.getNickname(player.getUniqueId());
        return nick != null ? nick : player.getName();
    }

    public Optional<Location> getLastLocation(UUID uuid) {
        Location loc = this.dataManager.getLastLocation(uuid);
        return Optional.ofNullable(loc);
    }

    public Optional<Location> getLastKnownLocation(UUID uuid) {
        return this.getLastLocation(uuid);
    }

    public long getPlaytime(UUID uuid) {
        return 0L;
    }

    public long getFirstJoin(UUID uuid) {
        if (this.plugin.getStatisticsManager() == null) {
            return 0L;
        }
        StatisticsManager.PlayerStats stats = this.plugin.getStatisticsManager().getStats(uuid);
        return stats != null ? stats.getFirstJoin() : 0L;
    }

    public long getLastSeen(UUID uuid) {
        if (this.plugin.getStatisticsManager() == null) {
            return 0L;
        }
        StatisticsManager.PlayerStats stats = this.plugin.getStatisticsManager().getStats(uuid);
        return stats != null ? stats.getLastSeen() : 0L;
    }

    public boolean isIgnoring(UUID player, UUID target) {
        return this.dataManager.isIgnoring(player, target);
    }

    public List<UUID> getIgnoredPlayers(UUID uuid) {
        Set<UUID> ignored = this.dataManager.getIgnoredPlayers(uuid);
        return ignored != null ? new ArrayList<UUID>(ignored) : Collections.emptyList();
    }
}

