/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.gui;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.gui.StaticTeleportItem;
import fr.skynex.mycommands.managers.GUIConfig;
import fr.skynex.mycommands.managers.MessageManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class WarpsGUI
implements Listener {
    private final MyCommands plugin;
    private final MessageManager msg;
    private final GUIConfig guiConfig;
    private final Map<UUID, Inventory> activeGUIs = new HashMap<UUID, Inventory>();

    public WarpsGUI(MyCommands plugin) {
        this.plugin = plugin;
        this.msg = plugin.getMessageManager();
        this.guiConfig = plugin.getGUIConfig();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void open(Player player) {
        if (!this.guiConfig.isWarpsGUIEnabled()) {
            this.msg.sendMessage((CommandSender)player, "gui.disabled");
            return;
        }
        if (!player.hasPermission("mycommands.gui.warps")) {
            this.msg.sendMessage((CommandSender)player, "no-permission");
            return;
        }
        Map<String, Location> warps = this.plugin.getDataManager().getWarps();
        int size = this.calculateInventorySize(warps.size(), this.guiConfig.getWarpsSizeConfig());
        HashMap<String, String> titlePlaceholders = new HashMap<String, String>();
        titlePlaceholders.put("count", String.valueOf(warps.size()));
        String title = this.guiConfig.replacePlaceholders(this.guiConfig.getWarpsTitle(), titlePlaceholders);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)title);
        int slot = 0;
        for (Map.Entry<String, Location> entry : warps.entrySet()) {
            if (slot >= size - 9) break;
            String warpName = entry.getKey();
            Location loc = entry.getValue();
            boolean hasPermission = true;
            if (this.plugin.getConfig().getBoolean("warps.per-warp-permission", false)) {
                hasPermission = player.hasPermission("mycommands.warp." + warpName);
            }
            ItemStack item = this.createWarpItem(warpName, loc, hasPermission);
            inv.setItem(slot, item);
            ++slot;
        }
        if (this.guiConfig.isStaticWarpsEnabled()) {
            List<StaticTeleportItem> staticWarps = this.guiConfig.getStaticWarps();
            for (StaticTeleportItem staticWarp : staticWarps) {
                if (staticWarp.hasPermission() && !player.hasPermission(staticWarp.getPermission())) continue;
                inv.setItem(staticWarp.getSlot(), staticWarp.createItem());
            }
        }
        this.addControlButtons(inv, size, warps.size());
        if (this.guiConfig.isWarpsDecorationEnabled()) {
            this.fillEmptySlots(inv, this.guiConfig.getWarpsDecorationMaterial(), this.guiConfig.getWarpsDecorationName());
        }
        this.activeGUIs.put(player.getUniqueId(), inv);
        player.openInventory(inv);
        this.playSound(player, this.guiConfig.getOpenGUISound());
    }

    private ItemStack createWarpItem(String warpName, Location loc, boolean hasPermission) {
        Material material = hasPermission ? this.guiConfig.getWarpItemMaterial() : this.guiConfig.getWarpLockedMaterial();
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        HashMap<String, String> namePlaceholders = new HashMap<String, String>();
        namePlaceholders.put("warp", warpName);
        String displayName = hasPermission ? this.guiConfig.getWarpItemName() : this.guiConfig.getWarpLockedName();
        meta.setDisplayName(this.guiConfig.replacePlaceholders(displayName, namePlaceholders));
        HashMap<String, String> lorePlaceholders = new HashMap<String, String>();
        lorePlaceholders.put("warp", warpName);
        lorePlaceholders.put("world", loc.getWorld() != null ? loc.getWorld().getName() : "unknown");
        lorePlaceholders.put("x", String.valueOf((int)loc.getX()));
        lorePlaceholders.put("y", String.valueOf((int)loc.getY()));
        lorePlaceholders.put("z", String.valueOf((int)loc.getZ()));
        ArrayList<String> lore = hasPermission ? new ArrayList<String>(this.guiConfig.getWarpItemLore()) : new ArrayList<String>(this.guiConfig.getWarpLockedLore());
        meta.setLore(this.guiConfig.replacePlaceholders(lore, lorePlaceholders));
        item.setItemMeta(meta);
        return item;
    }

    private void addControlButtons(Inventory inv, int size, int warpCount) {
        int lastLineStart = size - 9;
        int infoButtonSlot = lastLineStart + 4;
        int closeButtonSlot = lastLineStart + 8;
        if (this.guiConfig.isWarpsInfoButtonEnabled()) {
            ItemStack infoButton = this.createInfoButton(warpCount);
            inv.setItem(infoButtonSlot, infoButton);
        }
        if (this.guiConfig.isWarpsCloseButtonEnabled()) {
            ItemStack closeButton = this.createCloseButton();
            inv.setItem(closeButtonSlot, closeButton);
        }
    }

    private ItemStack createInfoButton(int warpCount) {
        ItemStack item = new ItemStack(this.guiConfig.getWarpsInfoButtonMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.guiConfig.getWarpsInfoButtonName());
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("count", String.valueOf(warpCount));
        ArrayList<String> lore = new ArrayList<String>(this.guiConfig.getWarpsInfoButtonLore());
        meta.setLore(this.guiConfig.replacePlaceholders(lore, placeholders));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createCloseButton() {
        ItemStack item = new ItemStack(this.guiConfig.getWarpsCloseButtonMaterial());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.guiConfig.getWarpsCloseButtonName());
        meta.setLore(this.guiConfig.getWarpsCloseButtonLore());
        item.setItemMeta(meta);
        return item;
    }

    private void fillEmptySlots(Inventory inv, Material material, String name) {
        ItemStack filler = new ItemStack(material);
        ItemMeta meta = filler.getItemMeta();
        meta.setDisplayName(name);
        filler.setItemMeta(meta);
        for (int i = 0; i < inv.getSize(); ++i) {
            if (inv.getItem(i) != null && inv.getItem(i).getType() != Material.AIR) continue;
            inv.setItem(i, filler);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack clicked;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.activeGUIs.containsKey(player.getUniqueId())) {
            return;
        }
        if (!event.getInventory().equals((Object)this.activeGUIs.get(player.getUniqueId()))) {
            return;
        }
        if (this.guiConfig.isPreventItemTake()) {
            event.setCancelled(true);
        }
        if ((clicked = event.getCurrentItem()) == null || clicked.getType() == Material.AIR) {
            return;
        }
        this.playSound(player, this.guiConfig.getClickItemSound());
        if (clicked.getType() == this.guiConfig.getWarpsCloseButtonMaterial()) {
            player.closeInventory();
            return;
        }
        if (clicked.getType() == this.guiConfig.getWarpsInfoButtonMaterial()) {
            return;
        }
        if (this.guiConfig.isWarpsDecorationEnabled() && clicked.getType() == this.guiConfig.getWarpsDecorationMaterial()) {
            return;
        }
        if (this.guiConfig.isStaticWarpsEnabled()) {
            List<StaticTeleportItem> staticWarps = this.guiConfig.getStaticWarps();
            for (StaticTeleportItem staticWarp : staticWarps) {
                if (event.getSlot() != staticWarp.getSlot() || !staticWarp.isEnabled()) continue;
                if (staticWarp.hasPermission() && !player.hasPermission(staticWarp.getPermission())) {
                    this.msg.sendMessage((CommandSender)player, "no-permission");
                    this.playSound(player, this.guiConfig.getErrorSound());
                    return;
                }
                if (staticWarp.hasValidLocation()) {
                    if (this.guiConfig.isCloseAfterTeleport()) {
                        player.closeInventory();
                    }
                    player.teleport(staticWarp.getLocation());
                    this.playSound(player, this.guiConfig.getTeleportSound());
                }
                return;
            }
        }
        if (clicked.getType() == this.guiConfig.getWarpItemMaterial()) {
            String warpName = this.extractWarpName(clicked);
            if (warpName == null) {
                return;
            }
            if (this.guiConfig.isCloseAfterTeleport()) {
                player.closeInventory();
            }
            player.performCommand("warp " + warpName);
            this.playSound(player, this.guiConfig.getTeleportSound());
        } else if (clicked.getType() == this.guiConfig.getWarpLockedMaterial()) {
            this.msg.sendMessage((CommandSender)player, "gui.warps.no-permission");
            this.playSound(player, this.guiConfig.getErrorSound());
        }
    }

    private String extractWarpName(ItemStack item) {
        if (!item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasDisplayName()) {
            return null;
        }
        String displayName = meta.getDisplayName();
        return ChatColor.stripColor((String)displayName);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        this.activeGUIs.remove(player.getUniqueId());
    }

    private int calculateInventorySize(int items, String sizeConfig) {
        if (sizeConfig.equalsIgnoreCase("auto")) {
            int neededSlots = items + 9;
            if (this.guiConfig.isStaticWarpsEnabled()) {
                List<StaticTeleportItem> staticWarps = this.guiConfig.getStaticWarps();
                for (StaticTeleportItem staticWarp : staticWarps) {
                    int requiredSlots;
                    if (!staticWarp.isEnabled() || (requiredSlots = staticWarp.getSlot() + 1) <= neededSlots) continue;
                    neededSlots = requiredSlots;
                }
            }
            int rows = (int)Math.ceil((double)neededSlots / 9.0);
            return Math.min(rows * 9, 54);
        }
        try {
            int size = Integer.parseInt(sizeConfig);
            size = (int)Math.ceil((double)size / 9.0) * 9;
            return Math.max(9, Math.min(size, 54));
        }
        catch (NumberFormatException e) {
            return 27;
        }
    }

    private void playSound(Player player, Sound sound) {
        if (!this.guiConfig.isSoundEnabled()) {
            return;
        }
        try {
            player.playSound(player.getLocation(), sound, this.guiConfig.getSoundVolume(), this.guiConfig.getSoundPitch());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

