/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.gui;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.managers.JailManager;
import fr.skynex.mycommands.managers.MessageManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class JailsGUI
implements Listener {
    private final MyCommands plugin;
    private final MessageManager msg;
    private final Map<UUID, Inventory> activeGUIs = new HashMap<UUID, Inventory>();

    public JailsGUI(MyCommands plugin) {
        this.plugin = plugin;
        this.msg = plugin.getMessageManager();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void open(Player player) {
        if (!player.hasPermission("mycommands.jails")) {
            this.msg.sendMessage((CommandSender)player, "no-permission");
            return;
        }
        JailManager jailManager = this.plugin.getJailManager();
        Map<UUID, JailManager.JailData> jailedPlayers = jailManager.getJailedPlayers();
        int size = this.calculateSize(jailedPlayers.size());
        String title = this.msg.colorize("&c&lPrisons &7(" + jailedPlayers.size() + ")");
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)title);
        int slot = 0;
        for (Map.Entry<UUID, JailManager.JailData> entry : jailedPlayers.entrySet()) {
            if (slot >= size - 9) break;
            UUID uuid = entry.getKey();
            JailManager.JailData data = entry.getValue();
            OfflinePlayer jailedPlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            ItemStack item = this.createJailedPlayerItem(jailedPlayer, data);
            inv.setItem(slot, item);
            ++slot;
        }
        ItemStack closeButton = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = closeButton.getItemMeta();
        closeMeta.setDisplayName(this.msg.colorize("&c&lFermer"));
        closeButton.setItemMeta(closeMeta);
        inv.setItem(size - 1, closeButton);
        this.activeGUIs.put(player.getUniqueId(), inv);
        player.openInventory(inv);
    }

    private ItemStack createJailedPlayerItem(OfflinePlayer jailedPlayer, JailManager.JailData data) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer(jailedPlayer);
            meta.setDisplayName(this.msg.colorize("&c" + jailedPlayer.getName()));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(this.msg.colorize("&7Prison: &f" + data.getJailName()));
            lore.add(this.msg.colorize("&7Raison: &f" + data.getReason()));
            if (data.isPermanent()) {
                lore.add(this.msg.colorize("&7Dur\u00e9e: &c&lPermanent"));
            } else {
                long remaining = data.getRemainingSeconds();
                lore.add(this.msg.colorize("&7Temps restant: &e" + this.formatDuration(remaining)));
            }
            lore.add("");
            lore.add(this.msg.colorize("&e&l\u25b6 Clic gauche &7pour lib\u00e9rer"));
            meta.setLore(lore);
            item.setItemMeta((ItemMeta)meta);
        }
        return item;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        SkullMeta meta;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.activeGUIs.containsKey(player.getUniqueId())) {
            return;
        }
        if (!event.getInventory().equals((Object)this.activeGUIs.get(player.getUniqueId()))) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (clicked.getType() == Material.BARRIER) {
            player.closeInventory();
            return;
        }
        if (clicked.getType() == Material.PLAYER_HEAD && event.isLeftClick() && (meta = (SkullMeta)clicked.getItemMeta()) != null && meta.getOwningPlayer() != null) {
            String playerName = meta.getOwningPlayer().getName();
            player.closeInventory();
            player.performCommand("unjail " + playerName);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        this.activeGUIs.remove(player.getUniqueId());
    }

    private int calculateSize(int items) {
        int neededSlots = items + 9;
        int rows = (int)Math.ceil((double)neededSlots / 9.0);
        return Math.min(rows * 9, 54);
    }

    private String formatDuration(long seconds) {
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (seconds < 3600L) {
            return seconds / 60L + "m";
        }
        if (seconds < 86400L) {
            return seconds / 3600L + "h";
        }
        return seconds / 86400L + "j";
    }
}

