/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.managers.JailManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class UnjailCommand
extends BaseCommand
implements TabCompleter {
    public UnjailCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.checkPermission(sender, "mycommands.unjail")) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/unjail <joueur>");
            return true;
        }
        String targetName = args[0];
        Player target = this.plugin.getServer().getPlayer(targetName);
        if (target == null) {
            this.msg.sendMessage(sender, "general.player-offline");
            return true;
        }
        JailManager jailManager = this.plugin.getJailManager();
        if (!jailManager.isJailed(target.getUniqueId())) {
            this.msg.sendMessage(sender, "commands.unjail.not-jailed", this.msg.placeholder("player", target.getName()));
            return true;
        }
        jailManager.releasePlayer(target, false);
        this.msg.sendMessage(sender, "commands.unjail.released", this.msg.placeholder("player", target.getName()));
        this.msg.sendMessage((CommandSender)target, "commands.unjail.you-released");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            JailManager jailManager = this.plugin.getJailManager();
            return jailManager.getJailedPlayers().keySet().stream().map(uuid -> {
                OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)uuid);
                return p.getName();
            }).filter(name -> name != null && name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

