/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.managers.StatisticsManager;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TpAcceptCommand
extends BaseCommand {
    public TpAcceptCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.tpaccept");
        if (player == null) {
            return true;
        }
        UUID requesterUUID = this.dataManager.getLatestTpaRequest(player.getUniqueId());
        if (requesterUUID == null) {
            this.msg.sendMessage((CommandSender)player, "teleport.tpa.no-request");
            return true;
        }
        Player requester = this.plugin.getServer().getPlayer(requesterUUID);
        if (requester == null) {
            this.msg.sendMessage((CommandSender)player, "general.player-not-found");
            this.dataManager.removeTpaRequest(requesterUUID, player.getUniqueId());
            return true;
        }
        this.dataManager.removeTpaRequest(requesterUUID, player.getUniqueId());
        this.cooldownManager.startTeleportDelay(requester, "tpa", () -> {
            requester.teleport(player.getLocation());
            this.msg.sendMessage((CommandSender)requester, "teleport.tpa.accepted-requester", this.msg.placeholder("player", player.getName()));
            this.msg.sendMessage((CommandSender)player, "teleport.tpa.accepted", this.msg.placeholder("player", requester.getName()));
            if (this.statsManager != null) {
                this.statsManager.incrementTeleports(requester, StatisticsManager.TeleportType.TPA);
            }
        });
        return true;
    }
}

