/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpeedCommand
extends BaseCommand {
    public SpeedCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player target;
        int speed;
        if (!this.checkPermission(sender, "mycommands.speed")) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/speed <1-10> [player]");
            return true;
        }
        try {
            speed = Integer.parseInt(args[0]);
            if (speed < 1 || speed > 10) {
                this.msg.sendMessage(sender, "speed.invalid");
                return true;
            }
        }
        catch (NumberFormatException e) {
            this.msg.sendMessage(sender, "speed.invalid");
            return true;
        }
        if (args.length >= 2) {
            target = this.plugin.getServer().getPlayer(args[1]);
            if (target == null) {
                this.msg.sendMessage(sender, "general.player-not-found");
                return true;
            }
        } else {
            target = this.getPlayer(sender);
            if (target == null) {
                return true;
            }
        }
        float speedValue = (float)speed / 10.0f;
        if (target.isFlying()) {
            target.setFlySpeed(speedValue);
        } else {
            target.setWalkSpeed(speedValue);
        }
        String type = target.isFlying() ? this.msg.getMessage("speed.fly") : this.msg.getMessage("speed.walk");
        System.out.println(type);
        if (target.equals((Object)sender)) {
            this.msg.sendMessage(sender, "speed.set", this.msg.placeholder("type", type), this.msg.placeholder("speed", String.valueOf(speed)));
        } else {
            this.msg.sendMessage(sender, "speed.set-other", this.msg.placeholder("player", target.getName()), this.msg.placeholder("type", type), this.msg.placeholder("speed", String.valueOf(speed)));
        }
        return true;
    }
}

