/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class SeenCommand
extends BaseCommand
implements TabCompleter {
    public SeenCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player target;
        if (!this.checkPermission(sender, "mycommands.seen")) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/seen <joueur>");
            return true;
        }
        String targetName = args[0];
        Player onlinePlayer = this.plugin.getServer().getPlayer(targetName);
        if (onlinePlayer != null) {
            target = onlinePlayer;
        } else {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)targetName);
            target = offlinePlayer;
        }
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            this.msg.sendMessage(sender, "general.player-not-found");
            return true;
        }
        if (target.isOnline()) {
            this.msg.sendMessage(sender, "commands.seen.online", this.msg.placeholder("player", target.getName()));
        } else {
            long lastPlayed = target.getLastPlayed();
            String lastSeenDate = this.formatDate(lastPlayed);
            String timeAgo = this.formatTimeAgo(System.currentTimeMillis() - lastPlayed);
            this.msg.sendMessage(sender, "commands.seen.offline", this.msg.placeholder("player", target.getName()), this.msg.placeholder("date", lastSeenDate), this.msg.placeholder("time", timeAgo));
        }
        return true;
    }

    private String formatDate(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        return sdf.format(new Date(timestamp));
    }

    private String formatTimeAgo(long milliseconds) {
        long seconds = milliseconds / 1000L;
        if (seconds < 60L) {
            return seconds + " seconde(s)";
        }
        if (seconds < 3600L) {
            return seconds / 60L + " minute(s)";
        }
        if (seconds < 86400L) {
            return seconds / 3600L + " heure(s)";
        }
        return seconds / 86400L + " jour(s)";
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

