/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.exceptions.ValidationException;
import fr.skynex.mycommands.utils.Validator;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class NickCommand
extends BaseCommand {
    public NickCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.nick");
        if (player == null) {
            return true;
        }
        if (this.hasArg(args, 0) && (args[0].equalsIgnoreCase("reset") || args[0].equalsIgnoreCase("off"))) {
            this.dataManager.removeNickname(player.getUniqueId());
            player.setDisplayName(player.getName());
            player.setPlayerListName(player.getName());
            this.msg.sendMessage((CommandSender)player, "nick.reset");
            return true;
        }
        if (!this.hasArg(args, 0)) {
            this.sendUsage(sender, "/nick <pseudo>");
            return true;
        }
        String nickname = args[0];
        try {
            Validator.validateNickname(nickname);
        }
        catch (ValidationException e) {
            this.msg.sendMessage((CommandSender)player, e.getMessageKey());
            return true;
        }
        if (this.plugin.getConfig().getBoolean("nickname.check-blacklist", true) && this.isBlacklisted(nickname)) {
            this.msg.sendMessage((CommandSender)player, "nick.invalid");
            return true;
        }
        if (this.plugin.getConfig().getBoolean("nickname.check-similarity", true)) {
            for (Player online : this.plugin.getServer().getOnlinePlayers()) {
                String strippedNick;
                String realName;
                if (online.equals((Object)player) || !(realName = online.getName()).equalsIgnoreCase(strippedNick = this.msg.stripColor(this.msg.colorize(nickname)))) continue;
                this.msg.sendMessage((CommandSender)player, "nick.taken");
                return true;
            }
        }
        String colorizedNick = this.msg.colorize(nickname);
        this.dataManager.setNickname(player.getUniqueId(), nickname);
        player.setDisplayName(colorizedNick);
        player.setPlayerListName(colorizedNick);
        this.msg.sendMessage((CommandSender)player, "nick.set", this.msg.placeholder("nick", colorizedNick));
        return true;
    }

    private boolean isBlacklisted(String nickname) {
        String lower = nickname.toLowerCase();
        for (String word : this.plugin.getConfig().getStringList("nickname.blacklist")) {
            if (!lower.contains(word.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

