/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class NearCommand
extends BaseCommand
implements TabCompleter {
    public NearCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.near");
        if (player == null) {
            return true;
        }
        int radius = this.plugin.getConfig().getInt("commands.near.default-radius", 100);
        if (args.length > 0) {
            try {
                radius = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Location loc = player.getLocation();
        ArrayList<String> nearbyPlayers = new ArrayList<String>();
        for (Player other : this.plugin.getServer().getOnlinePlayers()) {
            double distance;
            if (other.equals((Object)player) || !other.getWorld().equals((Object)player.getWorld()) || this.dataManager.isVanished(other.getUniqueId()) && !player.hasPermission("mycommands.vanish.see") || !((distance = loc.distance(other.getLocation())) <= (double)radius)) continue;
            nearbyPlayers.add(this.msg.colorize("&e" + other.getName() + " &7(" + (int)distance + "m)"));
        }
        if (nearbyPlayers.isEmpty()) {
            this.msg.sendMessage((CommandSender)player, "commands.near.no-players", this.msg.placeholder("radius", String.valueOf(radius)));
        } else {
            this.msg.sendMessage((CommandSender)player, "commands.near.header", this.msg.placeholder("count", String.valueOf(nearbyPlayers.size())), this.msg.placeholder("radius", String.valueOf(radius)));
            for (String playerInfo : nearbyPlayers) {
                player.sendMessage(this.msg.colorize("  &7\u2022 " + playerInfo));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> suggestions = Arrays.asList("10", "25", "50", "100", "200", "500");
            String input = args[0];
            return suggestions.stream().filter(s -> s.startsWith(input)).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

