/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class IgnoreCommand
extends BaseCommand {
    public IgnoreCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player target;
        Player player = this.getPlayerWithPermission(sender, "mycommands.ignore");
        if (player == null) {
            return true;
        }
        if (args.length < 1) {
            Set<UUID> ignored = this.dataManager.getIgnoredPlayers(player.getUniqueId());
            if (ignored.isEmpty()) {
                this.msg.sendMessage((CommandSender)player, "ignore.list-empty");
                return true;
            }
            ArrayList<String> names = new ArrayList<String>();
            for (UUID uuid : ignored) {
                OfflinePlayer offline = this.plugin.getServer().getOfflinePlayer(uuid);
                if (offline.getName() == null) continue;
                names.add(offline.getName());
            }
            this.msg.sendMessage((CommandSender)player, "ignore.list-header");
            for (String name : names) {
                this.msg.sendMessage((CommandSender)player, "ignore.list-item", this.msg.placeholder("player", name));
            }
            this.msg.sendMessage((CommandSender)player, "ignore.list-footer");
        }
        if ((target = this.plugin.getServer().getPlayer(args[0])) == null) {
            this.msg.sendMessage((CommandSender)player, "general.player-not-found");
            return true;
        }
        if (target.equals((Object)player)) {
            this.msg.sendMessage((CommandSender)player, "ignore.self");
            return true;
        }
        boolean nowIgnoring = this.dataManager.toggleIgnore(player.getUniqueId(), target.getUniqueId());
        this.msg.sendMessage((CommandSender)player, nowIgnoring ? "ignore.added" : "ignore.removed", this.msg.placeholder("player", target.getName()));
        return true;
    }
}

