/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EnchantCommand
extends BaseCommand
implements TabCompleter {
    public EnchantCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Enchantment enchantment;
        Player player = this.getPlayerWithPermission(sender, "mycommands.enchant");
        if (player == null) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/enchant <enchantment> [level]");
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            this.msg.sendMessage((CommandSender)player, "commands.enchant.no-item");
            return true;
        }
        String enchantName = args[0].toLowerCase();
        int level = 1;
        if (args.length > 1) {
            try {
                level = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                this.msg.sendMessage((CommandSender)player, "general.invalid-arguments");
                return true;
            }
        }
        if ((enchantment = this.getEnchantment(enchantName)) == null) {
            this.msg.sendMessage((CommandSender)player, "commands.enchant.invalid-enchantment", this.msg.placeholder("enchantment", enchantName));
            return true;
        }
        if (!player.hasPermission("mycommands.enchant.unsafe") && level > enchantment.getMaxLevel()) {
            level = enchantment.getMaxLevel();
        }
        item.addUnsafeEnchantment(enchantment, level);
        this.msg.sendMessage((CommandSender)player, "commands.enchant.success", this.msg.placeholder("enchantment", enchantment.getKey().getKey()), this.msg.placeholder("level", String.valueOf(level)));
        return true;
    }

    private Enchantment getEnchantment(String name) {
        NamespacedKey key = NamespacedKey.minecraft((String)name);
        Enchantment ench = (Enchantment)Registry.ENCHANTMENT.get(key);
        if (ench != null) {
            return ench;
        }
        for (Enchantment e : Registry.ENCHANTMENT) {
            if (!e.getKey().getKey().equalsIgnoreCase(name) && !e.getKey().getKey().contains(name.toLowerCase())) continue;
            return e;
        }
        return null;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            for (Enchantment enchantment : Registry.ENCHANTMENT) {
                completions.add(enchantment.getKey().getKey());
            }
            String input = args[0].toLowerCase();
            return completions.stream().filter(s -> s.toLowerCase().startsWith(input)).sorted().collect(Collectors.toList());
        }
        if (args.length == 2) {
            Enchantment enchantment = this.getEnchantment(args[0]);
            if (enchantment != null) {
                int maxLevel = enchantment.getMaxLevel();
                for (int i = 1; i <= maxLevel; ++i) {
                    completions.add(String.valueOf(i));
                }
                if (sender.hasPermission("mycommands.enchant.unsafe")) {
                    completions.addAll(Arrays.asList("10", "50", "100", "255"));
                }
            } else {
                completions.addAll(Arrays.asList("1", "2", "3", "4", "5"));
            }
            String input = args[1];
            return completions.stream().filter(s -> s.startsWith(input)).collect(Collectors.toList());
        }
        return completions;
    }
}

