/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.managers.ConfirmationManager;
import fr.skynex.mycommands.managers.EffectsManager;
import fr.skynex.mycommands.managers.SoundManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DelWarpCommand
extends BaseCommand {
    private final ConfirmationManager confirmationManager;
    private final EffectsManager effectsManager;
    private final SoundManager soundManager;

    public DelWarpCommand(MyCommands plugin) {
        super(plugin);
        this.confirmationManager = plugin.getConfirmationManager();
        this.effectsManager = plugin.getEffectsManager();
        this.soundManager = plugin.getSoundManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.checkPermission(sender, "mycommands.delwarp")) {
            if (sender instanceof Player) {
                this.soundManager.playError((Player)sender);
            }
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/delwarp <nom>");
            if (sender instanceof Player) {
                this.soundManager.playError((Player)sender);
            }
            return true;
        }
        String warpName = args[0];
        if (!this.dataManager.warpExists(warpName)) {
            this.msg.sendMessage(sender, "teleport.warp.not-found", this.msg.placeholder("warp", warpName));
            if (sender instanceof Player) {
                this.soundManager.playError((Player)sender);
            }
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.plugin.getConfig().getBoolean("confirmations.enabled", true) && this.plugin.getConfig().getBoolean("confirmations.require-for.warp-delete", true)) {
                this.confirmationManager.requestWarpDelete(player, warpName, () -> this.performWarpDeletion(sender, warpName));
                return true;
            }
        }
        this.performWarpDeletion(sender, warpName);
        return true;
    }

    private void performWarpDeletion(CommandSender sender, String warpName) {
        this.dataManager.deleteWarp(warpName);
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.effectsManager.playHomeDeletedEffect(player.getLocation());
            this.soundManager.play(player, SoundManager.SoundType.DELETE);
        }
        this.msg.sendMessage(sender, "teleport.warp.deleted", this.msg.placeholder("warp", warpName));
    }
}

