/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.managers.ConfirmationManager;
import fr.skynex.mycommands.managers.EffectsManager;
import fr.skynex.mycommands.managers.SoundManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DelHomeCommand
extends BaseCommand {
    private final ConfirmationManager confirmationManager;
    private final EffectsManager effectsManager;
    private final SoundManager soundManager;

    public DelHomeCommand(MyCommands plugin) {
        super(plugin);
        this.confirmationManager = plugin.getConfirmationManager();
        this.effectsManager = plugin.getEffectsManager();
        this.soundManager = plugin.getSoundManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.delhome");
        if (player == null) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/delhome <nom>");
            this.soundManager.playError(player);
            return true;
        }
        String homeName = args[0];
        if (!this.dataManager.homeExists(player.getUniqueId(), homeName)) {
            this.msg.sendMessage((CommandSender)player, "teleport.home.not-found", this.msg.placeholder("home", homeName));
            this.soundManager.playError(player);
            return true;
        }
        if (this.plugin.getConfig().getBoolean("confirmations.enabled", true) && this.plugin.getConfig().getBoolean("confirmations.require-for.home-delete", true)) {
            int teleportCount = 0;
            if (this.statsManager != null) {
                teleportCount = this.statsManager.getHomeTeleports(player, homeName);
            }
            this.confirmationManager.requestHomeDelete(player, homeName, teleportCount, "cr\u00e9\u00e9 r\u00e9cemment", () -> this.performHomeDeletion(player, homeName));
            return true;
        }
        this.performHomeDeletion(player, homeName);
        return true;
    }

    private void performHomeDeletion(Player player, String homeName) {
        this.dataManager.deleteHome(player.getUniqueId(), homeName);
        this.effectsManager.playHomeDeletedEffect(player.getLocation());
        this.soundManager.play(player, SoundManager.SoundType.DELETE);
        this.msg.sendMessage((CommandSender)player, "teleport.home.deleted", this.msg.placeholder("home", homeName));
    }
}

