/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.AFKCommand;
import fr.skynex.mycommands.commands.AnvilCommand;
import fr.skynex.mycommands.commands.BackCommand;
import fr.skynex.mycommands.commands.BroadcastCommand;
import fr.skynex.mycommands.commands.CartographyCommand;
import fr.skynex.mycommands.commands.ClearCommand;
import fr.skynex.mycommands.commands.DayCommand;
import fr.skynex.mycommands.commands.DelHomeCommand;
import fr.skynex.mycommands.commands.DelJailCommand;
import fr.skynex.mycommands.commands.DelWarpCommand;
import fr.skynex.mycommands.commands.DisposalCommand;
import fr.skynex.mycommands.commands.EnchantCommand;
import fr.skynex.mycommands.commands.EnderchestCommand;
import fr.skynex.mycommands.commands.FeedCommand;
import fr.skynex.mycommands.commands.FlyCommand;
import fr.skynex.mycommands.commands.FreezeCommand;
import fr.skynex.mycommands.commands.GamemodeCommand;
import fr.skynex.mycommands.commands.GiveCommand;
import fr.skynex.mycommands.commands.GodCommand;
import fr.skynex.mycommands.commands.GrindstoneCommand;
import fr.skynex.mycommands.commands.HatCommand;
import fr.skynex.mycommands.commands.HealCommand;
import fr.skynex.mycommands.commands.HelpCommand;
import fr.skynex.mycommands.commands.HomeCommand;
import fr.skynex.mycommands.commands.HomeGUICommand;
import fr.skynex.mycommands.commands.HomesCommand;
import fr.skynex.mycommands.commands.IgnoreCommand;
import fr.skynex.mycommands.commands.InvseeCommand;
import fr.skynex.mycommands.commands.JailCommand;
import fr.skynex.mycommands.commands.JailGUICommand;
import fr.skynex.mycommands.commands.JailsCommand;
import fr.skynex.mycommands.commands.KickCommand;
import fr.skynex.mycommands.commands.ListCommand;
import fr.skynex.mycommands.commands.LoomCommand;
import fr.skynex.mycommands.commands.MeCommand;
import fr.skynex.mycommands.commands.MidnightCommand;
import fr.skynex.mycommands.commands.MoreCommand;
import fr.skynex.mycommands.commands.MotdCommand;
import fr.skynex.mycommands.commands.MsgCommand;
import fr.skynex.mycommands.commands.NearCommand;
import fr.skynex.mycommands.commands.NickCommand;
import fr.skynex.mycommands.commands.NightCommand;
import fr.skynex.mycommands.commands.NoonCommand;
import fr.skynex.mycommands.commands.PTimeCommand;
import fr.skynex.mycommands.commands.PWeatherCommand;
import fr.skynex.mycommands.commands.RainCommand;
import fr.skynex.mycommands.commands.RealnameCommand;
import fr.skynex.mycommands.commands.ReloadCommand;
import fr.skynex.mycommands.commands.RepairCommand;
import fr.skynex.mycommands.commands.ReplyCommand;
import fr.skynex.mycommands.commands.RulesCommand;
import fr.skynex.mycommands.commands.SeenCommand;
import fr.skynex.mycommands.commands.SetHomeCommand;
import fr.skynex.mycommands.commands.SetJailCommand;
import fr.skynex.mycommands.commands.SetSpawnCommand;
import fr.skynex.mycommands.commands.SetWarpCommand;
import fr.skynex.mycommands.commands.SkullCommand;
import fr.skynex.mycommands.commands.SmithingCommand;
import fr.skynex.mycommands.commands.SocialSpyCommand;
import fr.skynex.mycommands.commands.SpawnCommand;
import fr.skynex.mycommands.commands.SpeedCommand;
import fr.skynex.mycommands.commands.StatsCommand;
import fr.skynex.mycommands.commands.StonecutterCommand;
import fr.skynex.mycommands.commands.StormCommand;
import fr.skynex.mycommands.commands.SuicideCommand;
import fr.skynex.mycommands.commands.SunCommand;
import fr.skynex.mycommands.commands.TeleportAllCommand;
import fr.skynex.mycommands.commands.TeleportCommand;
import fr.skynex.mycommands.commands.TeleportHereCommand;
import fr.skynex.mycommands.commands.TimeCommand;
import fr.skynex.mycommands.commands.TpAcceptCommand;
import fr.skynex.mycommands.commands.TpDenyCommand;
import fr.skynex.mycommands.commands.TpaCommand;
import fr.skynex.mycommands.commands.UnjailCommand;
import fr.skynex.mycommands.commands.VanishCommand;
import fr.skynex.mycommands.commands.WarpCommand;
import fr.skynex.mycommands.commands.WarpGUICommand;
import fr.skynex.mycommands.commands.WarpsCommand;
import fr.skynex.mycommands.commands.WeatherCommand;
import fr.skynex.mycommands.commands.WorkbenchCommand;
import fr.skynex.mycommands.gui.HomesGUI;
import fr.skynex.mycommands.gui.JailsGUI;
import fr.skynex.mycommands.gui.WarpsGUI;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;

public class CommandRegistry {
    private final MyCommands plugin;
    private final Map<String, CommandExecutor> registeredCommands = new HashMap<String, CommandExecutor>();
    private int successCount = 0;
    private int failureCount = 0;

    public CommandRegistry(MyCommands plugin) {
        this.plugin = plugin;
    }

    public int registerAll() {
        this.registerAdminCommands();
        this.registerPlayerCommands();
        this.registerWarpCommands();
        this.registerMessageCommands();
        this.registerSpecialCommands();
        if (this.failureCount > 0) {
            this.plugin.getLogger().warning("Some commands could not be registered. Check plugin.yml!");
        }
        return this.successCount;
    }

    private void registerAdminCommands() {
        this.register("gamemode", new GamemodeCommand(this.plugin));
        this.register("fly", new FlyCommand(this.plugin));
        this.register("heal", new HealCommand(this.plugin));
        this.register("feed", new FeedCommand(this.plugin));
        this.register("god", new GodCommand(this.plugin));
        this.register("vanish", new VanishCommand(this.plugin));
        this.register("tp", new TeleportCommand(this.plugin));
        this.register("tphere", new TeleportHereCommand(this.plugin));
        this.register("tpall", new TeleportAllCommand(this.plugin));
        this.register("give", new GiveCommand(this.plugin));
        this.register("clear", new ClearCommand(this.plugin));
        this.register("invsee", new InvseeCommand(this.plugin));
        this.register("enderchest", new EnderchestCommand(this.plugin));
        this.register("weather", new WeatherCommand(this.plugin));
        this.register("time", new TimeCommand(this.plugin));
        this.register("speed", new SpeedCommand(this.plugin));
        this.register("broadcast", new BroadcastCommand(this.plugin));
        this.register("kick", new KickCommand(this.plugin));
        this.register("freeze", new FreezeCommand(this.plugin));
        this.register("setspawn", new SetSpawnCommand(this.plugin));
        this.register("more", new MoreCommand(this.plugin));
        this.register("repair", new RepairCommand(this.plugin));
        this.register("enchant", new EnchantCommand(this.plugin));
        this.register("anvil", new AnvilCommand(this.plugin));
        this.register("day", new DayCommand(this.plugin));
        this.register("night", new NightCommand(this.plugin));
        this.register("noon", new NoonCommand(this.plugin));
        this.register("midnight", new MidnightCommand(this.plugin));
        this.register("sun", new SunCommand(this.plugin));
        this.register("rain", new RainCommand(this.plugin));
        this.register("storm", new StormCommand(this.plugin));
        this.register("ptime", new PTimeCommand(this.plugin));
        this.register("pweather", new PWeatherCommand(this.plugin));
        this.register("workbench", new WorkbenchCommand(this.plugin));
        this.register("cartography", new CartographyCommand(this.plugin));
        this.register("grindstone", new GrindstoneCommand(this.plugin));
        this.register("smithing", new SmithingCommand(this.plugin));
        this.register("loom", new LoomCommand(this.plugin));
        this.register("stonecutter", new StonecutterCommand(this.plugin));
        this.register("disposal", new DisposalCommand(this.plugin));
        this.register("hat", new HatCommand(this.plugin));
        this.register("skull", new SkullCommand(this.plugin));
        this.register("jail", new JailCommand(this.plugin));
        this.register("unjail", new UnjailCommand(this.plugin));
        this.register("setjail", new SetJailCommand(this.plugin));
        this.register("deljail", new DelJailCommand(this.plugin));
        this.register("jails", new JailsCommand(this.plugin));
    }

    private void registerPlayerCommands() {
        this.register("spawn", new SpawnCommand(this.plugin));
        this.register("home", new HomeCommand(this.plugin));
        this.register("sethome", new SetHomeCommand(this.plugin));
        this.register("delhome", new DelHomeCommand(this.plugin));
        this.register("homes", new HomesCommand(this.plugin));
        this.register("back", new BackCommand(this.plugin));
        this.register("tpa", new TpaCommand(this.plugin));
        this.register("tpaccept", new TpAcceptCommand(this.plugin));
        this.register("tpdeny", new TpDenyCommand(this.plugin));
        this.register("suicide", new SuicideCommand(this.plugin));
        this.register("ignore", new IgnoreCommand(this.plugin));
        this.register("socialspy", new SocialSpyCommand(this.plugin));
        this.register("nick", new NickCommand(this.plugin));
        this.register("stats", new StatsCommand(this.plugin));
        this.register("afk", new AFKCommand(this.plugin));
        this.register("me", new MeCommand(this.plugin));
        this.register("near", new NearCommand(this.plugin));
        this.register("realname", new RealnameCommand(this.plugin));
        this.register("seen", new SeenCommand(this.plugin));
        this.register("list", new ListCommand(this.plugin));
        this.register("motd", new MotdCommand(this.plugin));
        this.register("rules", new RulesCommand(this.plugin));
    }

    private void registerWarpCommands() {
        this.register("warp", new WarpCommand(this.plugin));
        this.register("setwarp", new SetWarpCommand(this.plugin));
        this.register("delwarp", new DelWarpCommand(this.plugin));
        this.register("warps", new WarpsCommand(this.plugin));
    }

    private void registerMessageCommands() {
        this.register("msg", new MsgCommand(this.plugin));
        this.register("reply", new ReplyCommand(this.plugin));
    }

    private void registerSpecialCommands() {
        this.register("mycommands", new ReloadCommand(this.plugin));
        if (this.plugin.getConfig().getBoolean("guis.homes-gui-enabled", true)) {
            HomesGUI homesGUI = new HomesGUI(this.plugin);
            this.register("homegui", new HomeGUICommand(this.plugin, homesGUI));
        }
        if (this.plugin.getConfig().getBoolean("guis.warps-gui-enabled", true)) {
            WarpsGUI warpsGUI = new WarpsGUI(this.plugin);
            this.register("warpgui", new WarpGUICommand(this.plugin, warpsGUI));
        }
        if (this.plugin.getConfig().getBoolean("jail.enabled", true)) {
            JailsGUI jailsGUI = new JailsGUI(this.plugin);
            this.register("jailgui", new JailGUICommand(this.plugin, jailsGUI));
        }
        this.register("help", new HelpCommand(this.plugin));
    }

    private void register(String name, CommandExecutor executor) {
        PluginCommand command = this.plugin.getCommand(name);
        if (command == null) {
            this.plugin.getLogger().warning(String.format("Command '%s' not found in plugin.yml!", name));
            ++this.failureCount;
            return;
        }
        command.setExecutor(executor);
        if (executor instanceof TabCompleter) {
            command.setTabCompleter((TabCompleter)executor);
        }
        this.registeredCommands.put(name, executor);
        ++this.successCount;
        if (this.plugin.getConfig().getBoolean("debug.enabled", false)) {
            this.plugin.getLogger().info("  \u2713 " + name);
        }
    }

    public int getCommandCount() {
        return this.registeredCommands.size();
    }
}

