/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.managers.CooldownManager;
import fr.skynex.mycommands.managers.DataManager;
import fr.skynex.mycommands.managers.EconomyManager;
import fr.skynex.mycommands.managers.MessageManager;
import fr.skynex.mycommands.managers.StatisticsManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class BaseCommand
implements CommandExecutor {
    protected final MyCommands plugin;
    protected final MessageManager msg;
    protected final DataManager dataManager;
    protected final CooldownManager cooldownManager;
    protected final StatisticsManager statsManager;
    protected final EconomyManager economyManager;

    public BaseCommand(MyCommands plugin) {
        this.plugin = plugin;
        this.msg = plugin.getMessageManager();
        this.dataManager = plugin.getDataManager();
        this.cooldownManager = plugin.getCooldownManager();
        this.statsManager = plugin.getStatisticsManager();
        this.economyManager = plugin.getEconomyManager();
    }

    protected boolean checkPermission(CommandSender sender, String permission) {
        if (!sender.hasPermission(permission)) {
            this.msg.sendMessage(sender, "general.no-permission");
            return false;
        }
        return true;
    }

    protected Player getPlayer(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.msg.sendMessage(sender, "general.command-player-only");
            return null;
        }
        return (Player)sender;
    }

    protected Player getPlayerWithPermission(CommandSender sender, String permission) {
        if (!this.checkPermission(sender, permission)) {
            return null;
        }
        return this.getPlayer(sender);
    }

    protected boolean checkCooldown(Player player, String action) {
        if (player.hasPermission("mycommands.cooldown.bypass") || player.isOp() && this.plugin.getConfig().getBoolean("cooldowns.bypass-for-ops", true)) {
            return true;
        }
        if (this.cooldownManager.hasCooldown(player.getUniqueId(), action)) {
            long remaining = this.cooldownManager.getRemainingCooldown(player.getUniqueId(), action);
            this.msg.sendMessage((CommandSender)player, "general.cooldown-active", this.msg.placeholder("time", this.msg.formatTime(remaining)));
            return false;
        }
        return true;
    }

    protected boolean checkEconomy(Player player, String action) {
        if (this.economyManager == null || !this.economyManager.isEnabled()) {
            return true;
        }
        if (player.hasPermission("mycommands.economy.bypass")) {
            this.msg.sendMessage((CommandSender)player, "economy.action-free");
            return true;
        }
        return this.economyManager.charge(player, action);
    }

    protected void refundEconomy(Player player, String action) {
        if (this.economyManager == null || !this.economyManager.isEnabled()) {
            return;
        }
        if (player.hasPermission("mycommands.economy.bypass")) {
            return;
        }
        this.economyManager.refund(player, action);
    }

    protected boolean startTeleportDelay(Player player, String action, Runnable onSuccess) {
        if (!this.checkCooldown(player, action)) {
            return false;
        }
        if (!this.checkEconomy(player, action)) {
            return false;
        }
        this.cooldownManager.startTeleportDelayWithCooldown(player, action, onSuccess);
        return true;
    }

    protected boolean hasArg(String[] args, int index) {
        return args.length > index && args[index] != null && !args[index].isEmpty();
    }

    protected String getArgOrDefault(String[] args, int index, String defaultValue) {
        return this.hasArg(args, index) ? args[index] : defaultValue;
    }

    protected Integer parseIntArg(String[] args, int index) {
        if (!this.hasArg(args, index)) {
            return null;
        }
        try {
            return Integer.parseInt(args[index]);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected Double parseDoubleArg(String[] args, int index) {
        if (!this.hasArg(args, index)) {
            return null;
        }
        try {
            return Double.parseDouble(args[index]);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected void sendUsage(CommandSender sender, String usage) {
        this.msg.sendMessage(sender, "general.invalid-usage", this.msg.placeholder("usage", usage));
    }
}

