/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.model;

import com.skynex.mylands.model.Cuboid;
import com.skynex.mylands.model.Land;
import com.skynex.mylands.model.LandMember;
import com.skynex.mylands.model.LandPermission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record LandV2(@NotNull UUID ownerId, @NotNull String name, @NotNull Cuboid cuboid, int level, @NotNull Map<UUID, LandMember> members, @Nullable Location home, boolean visitsOpen) {
    public static LandV2 fromLegacy(@NotNull Land oldLand) {
        Map<UUID, LandMember> members = oldLand.coOwners().stream().collect(Collectors.toMap(uuid -> uuid, uuid -> new LandMember((UUID)uuid, oldLand.ownerId(), "member", System.currentTimeMillis())));
        return new LandV2(oldLand.ownerId(), oldLand.name(), oldLand.cuboid(), oldLand.level(), members, oldLand.home(), oldLand.visitsOpen());
    }

    public Land toLegacy() {
        HashSet<UUID> coOwners = new HashSet<UUID>(this.members.keySet());
        return new Land(this.ownerId, this.name, this.cuboid, this.level, coOwners, this.home, this.visitsOpen);
    }

    public boolean isOwner(@NotNull UUID playerId) {
        return this.ownerId.equals(playerId);
    }

    public boolean isMember(@NotNull UUID playerId) {
        return this.members.containsKey(playerId);
    }

    public boolean hasAccess(@NotNull UUID playerId) {
        return this.isOwner(playerId) || this.isMember(playerId);
    }

    @Deprecated
    public boolean hasPermission(@NotNull UUID playerId, @NotNull LandPermission permission) {
        return this.isOwner(playerId);
    }

    public Optional<LandMember> getMember(@NotNull UUID playerId) {
        return Optional.ofNullable(this.members.get(playerId));
    }

    @Nullable
    public String getGradeId(@NotNull UUID playerId) {
        if (this.isOwner(playerId)) {
            return "owner";
        }
        LandMember member = this.members.get(playerId);
        return member != null ? member.gradeId() : null;
    }

    public boolean contains(@NotNull Location location) {
        return this.cuboid.contains(location);
    }

    public LandV2 withLevel(int newLevel) {
        return new LandV2(this.ownerId, this.name, this.cuboid, newLevel, this.members, this.home, this.visitsOpen);
    }

    public LandV2 withMembers(@NotNull Map<UUID, LandMember> newMembers) {
        return new LandV2(this.ownerId, this.name, this.cuboid, this.level, new HashMap<UUID, LandMember>(newMembers), this.home, this.visitsOpen);
    }

    public LandV2 addMember(@NotNull UUID playerId, @NotNull String gradeId) {
        HashMap<UUID, LandMember> newMembers = new HashMap<UUID, LandMember>(this.members);
        newMembers.put(playerId, new LandMember(playerId, this.ownerId, gradeId, System.currentTimeMillis()));
        return new LandV2(this.ownerId, this.name, this.cuboid, this.level, newMembers, this.home, this.visitsOpen);
    }

    public LandV2 removeMember(@NotNull UUID playerId) {
        HashMap<UUID, LandMember> newMembers = new HashMap<UUID, LandMember>(this.members);
        newMembers.remove(playerId);
        return new LandV2(this.ownerId, this.name, this.cuboid, this.level, newMembers, this.home, this.visitsOpen);
    }

    public LandV2 updateMemberGrade(@NotNull UUID playerId, @NotNull String newGradeId) {
        HashMap<UUID, LandMember> newMembers = new HashMap<UUID, LandMember>(this.members);
        LandMember currentMember = (LandMember)newMembers.get(playerId);
        if (currentMember != null) {
            newMembers.put(playerId, new LandMember(playerId, this.ownerId, newGradeId, currentMember.joinedAt()));
        }
        return new LandV2(this.ownerId, this.name, this.cuboid, this.level, newMembers, this.home, this.visitsOpen);
    }

    @Deprecated
    public LandV2 updateMemberPermissions(@NotNull UUID playerId, @NotNull Set<LandPermission> permissions) {
        return this;
    }

    public LandV2 withHome(@Nullable Location newHome) {
        return new LandV2(this.ownerId, this.name, this.cuboid, this.level, this.members, newHome, this.visitsOpen);
    }

    public LandV2 withCuboid(@NotNull Cuboid newCuboid) {
        return new LandV2(this.ownerId, this.name, newCuboid, this.level, this.members, this.home, this.visitsOpen);
    }

    public LandV2 withVisitsOpen(boolean newVisitsOpen) {
        return new LandV2(this.ownerId, this.name, this.cuboid, this.level, this.members, this.home, newVisitsOpen);
    }

    public Set<UUID> getMemberIds() {
        return new HashSet<UUID>(this.members.keySet());
    }

    public int getMemberCount() {
        return this.members.size();
    }
}

