/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.model;

import com.skynex.mylands.model.Cuboid;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Land(@NotNull UUID ownerId, @NotNull String name, @NotNull Cuboid cuboid, int level, @NotNull Set<UUID> coOwners, @Nullable Location home, boolean visitsOpen) {
    public boolean isOwner(@NotNull UUID playerId) {
        return this.ownerId.equals(playerId);
    }

    public boolean isCoOwner(@NotNull UUID playerId) {
        return this.coOwners.contains(playerId);
    }

    public boolean hasAccess(@NotNull UUID playerId) {
        return this.isOwner(playerId) || this.isCoOwner(playerId);
    }

    public boolean contains(@NotNull Location location) {
        return this.cuboid.contains(location);
    }

    public Land withLevel(int newLevel) {
        return new Land(this.ownerId, this.name, this.cuboid, newLevel, this.coOwners, this.home, this.visitsOpen);
    }

    public Land withCoOwners(@NotNull Set<UUID> newCoOwners) {
        return new Land(this.ownerId, this.name, this.cuboid, this.level, newCoOwners, this.home, this.visitsOpen);
    }

    public Land withHome(@Nullable Location newHome) {
        return new Land(this.ownerId, this.name, this.cuboid, this.level, this.coOwners, newHome, this.visitsOpen);
    }

    public Land withCuboid(@NotNull Cuboid newCuboid) {
        return new Land(this.ownerId, this.name, newCuboid, this.level, this.coOwners, this.home, this.visitsOpen);
    }

    public Land withVisitsOpen(boolean newVisitsOpen) {
        return new Land(this.ownerId, this.name, this.cuboid, this.level, this.coOwners, this.home, newVisitsOpen);
    }
}

