/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.gui;

import com.skynex.mylands.gui.GuiConfig;
import com.skynex.mylands.gui.GuiManager;
import com.skynex.mylands.gui.LandGui;
import com.skynex.mylands.model.Land;
import com.skynex.mylands.service.LandService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public class ConfigurableLeaderboardGui
implements LandGui {
    private static final String GUI_NAME = "leaderboard_menu";
    private final GuiManager guiManager;
    private final GuiConfig guiConfig;
    private final LandService landService;
    private LeaderboardType currentType;

    public ConfigurableLeaderboardGui(@NotNull GuiManager guiManager, @NotNull GuiConfig guiConfig, @NotNull LandService landService) {
        this(guiManager, guiConfig, landService, LeaderboardType.LEVEL);
    }

    public ConfigurableLeaderboardGui(@NotNull GuiManager guiManager, @NotNull GuiConfig guiConfig, @NotNull LandService landService, @NotNull LeaderboardType type) {
        this.guiManager = guiManager;
        this.guiConfig = guiConfig;
        this.landService = landService;
        this.currentType = type;
    }

    @Override
    @NotNull
    public Inventory createInventory() {
        Inventory inv = Bukkit.createInventory(null, (int)this.getSize(), (String)this.getTitle());
        this.createItem(inv, "level");
        this.createItem(inv, "size");
        this.createItem(inv, "members");
        this.createItem(inv, "wealth");
        this.createItem(inv, "quests");
        this.displayLeaderboard(inv);
        this.createItem(inv, "back");
        return inv;
    }

    private void displayLeaderboard(@NotNull Inventory inv) {
        ArrayList<Land> allLands = new ArrayList<Land>(this.landService.getAllLands());
        List sortedLands = switch (this.currentType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> allLands.stream().sorted(Comparator.comparingInt(Land::level).reversed()).limit(17L).collect(Collectors.toList());
            case 1 -> allLands.stream().sorted(Comparator.comparingInt(l -> -l.cuboid().getSizeX())).limit(17L).collect(Collectors.toList());
            case 2 -> allLands.stream().sorted(Comparator.comparingInt(l -> -l.coOwners().size())).limit(17L).collect(Collectors.toList());
            case 3 -> allLands.stream().sorted(Comparator.comparingInt(l -> -(l.level() * 10000))).limit(17L).collect(Collectors.toList());
            case 4 -> allLands.stream().sorted(Comparator.comparingInt(Land::level).reversed()).limit(17L).collect(Collectors.toList());
        };
        for (int i = 0; i < Math.min(sortedLands.size(), 17); ++i) {
            Land land = (Land)sortedLands.get(i);
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)land.ownerId());
            ItemStack item = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)item.getItemMeta();
            if (meta != null) {
                meta.setOwningPlayer(player);
                String rank = this.getRankColor(i + 1) + "#" + (i + 1);
                meta.setDisplayName(rank + " \u00a7f" + player.getName());
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                lore.add("\u00a77Land: \u00a7e" + land.name());
                switch (this.currentType.ordinal()) {
                    case 0: {
                        lore.add("\u00a77\u2b50 Level: \u00a7e" + land.level());
                        break;
                    }
                    case 1: {
                        lore.add("\u00a77\ud83d\udccf Size: \u00a7b" + land.cuboid().getSizeX() + "x" + land.cuboid().getSizeZ());
                        break;
                    }
                    case 2: {
                        lore.add("\u00a77\ud83d\udc65 Members: \u00a7d" + land.coOwners().size());
                        break;
                    }
                    case 3: {
                        lore.add("\u00a77\ud83d\udcb0 Value: \u00a76" + land.level() * 10000 + " coins");
                        break;
                    }
                    case 4: {
                        lore.add("\u00a77\ud83d\udcdc Quests: \u00a750");
                    }
                }
                lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
                meta.setLore(lore);
                item.setItemMeta((ItemMeta)meta);
            }
            inv.setItem(9 + i, item);
        }
    }

    private String getRankColor(int rank) {
        return switch (rank) {
            case 1 -> "\u00a76\u00a7l";
            case 2 -> "\u00a77\u00a7l";
            case 3 -> "\u00a7c\u00a7l";
            default -> "\u00a7e";
        };
    }

    private void createItem(@NotNull Inventory inv, @NotNull String itemName) {
        GuiConfig.GuiItemConfig itemConfig = this.guiConfig.getItem(GUI_NAME, itemName);
        if (itemConfig == null) {
            return;
        }
        ItemStack item = new ItemStack(itemConfig.getMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(itemConfig.getName());
            ArrayList<String> lore = new ArrayList<String>(itemConfig.getLore(new HashMap<String, String>()));
            if (this.isCurrentCategory(itemName)) {
                lore.add("");
                lore.add("\u00a7a\u00a7l\u2714 Currently Selected");
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        inv.setItem(itemConfig.getSlot(), item);
    }

    private boolean isCurrentCategory(String itemName) {
        return switch (itemName) {
            case "level" -> {
                if (this.currentType == LeaderboardType.LEVEL) {
                    yield true;
                }
                yield false;
            }
            case "size" -> {
                if (this.currentType == LeaderboardType.SIZE) {
                    yield true;
                }
                yield false;
            }
            case "members" -> {
                if (this.currentType == LeaderboardType.MEMBERS) {
                    yield true;
                }
                yield false;
            }
            case "wealth" -> {
                if (this.currentType == LeaderboardType.WEALTH) {
                    yield true;
                }
                yield false;
            }
            case "quests" -> {
                if (this.currentType == LeaderboardType.QUESTS) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public void handleClick(@NotNull Player player, int slot, @NotNull ItemStack item, @NotNull ClickType clickType) {
        String itemName = this.getItemNameBySlot(slot);
        if (itemName == null) {
            return;
        }
        switch (itemName) {
            case "level": {
                this.switchCategory(player, LeaderboardType.LEVEL);
                break;
            }
            case "size": {
                this.switchCategory(player, LeaderboardType.SIZE);
                break;
            }
            case "members": {
                this.switchCategory(player, LeaderboardType.MEMBERS);
                break;
            }
            case "wealth": {
                this.switchCategory(player, LeaderboardType.WEALTH);
                break;
            }
            case "quests": {
                this.switchCategory(player, LeaderboardType.QUESTS);
                break;
            }
            case "back": {
                this.handleBack(player);
            }
        }
    }

    private void switchCategory(Player player, LeaderboardType type) {
        if (this.currentType != type) {
            this.guiManager.openGui(player, new ConfigurableLeaderboardGui(this.guiManager, this.guiConfig, this.landService, type));
        }
    }

    private String getItemNameBySlot(int slot) {
        String[] items;
        for (String itemName : items = new String[]{"level", "size", "members", "wealth", "quests", "back"}) {
            GuiConfig.GuiItemConfig config = this.guiConfig.getItem(GUI_NAME, itemName);
            if (config == null || config.getSlot() != slot) continue;
            return itemName;
        }
        return null;
    }

    private void handleBack(Player player) {
        player.closeInventory();
        player.performCommand("lands menu");
    }

    @Override
    @NotNull
    public String getTitle() {
        String title = this.guiConfig.getTitle(GUI_NAME).replace("&", "\u00a7");
        String typeStr = switch (this.currentType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "Levels";
            case 1 -> "Sizes";
            case 2 -> "Communities";
            case 3 -> "Wealth";
            case 4 -> "Questers";
        };
        return title + " \u00a78- \u00a7e" + typeStr;
    }

    @Override
    public int getSize() {
        return this.guiConfig.getSize(GUI_NAME);
    }

    public static enum LeaderboardType {
        LEVEL,
        SIZE,
        MEMBERS,
        WEALTH,
        QUESTS;

    }
}

