/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.database;

import com.skynex.mylands.database.DatabaseManager;
import com.skynex.mylands.model.Cuboid;
import com.skynex.mylands.model.Land;
import com.skynex.mylands.util.PluginLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LandRepository {
    private final DatabaseManager databaseManager;

    public LandRepository(@NotNull DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
    }

    public CompletableFuture<Void> saveLand(@NotNull Land land) {
        return this.databaseManager.executeAsync(conn -> {
            String sql = this.databaseManager.getDatabaseType().equals("mysql") || this.databaseManager.getDatabaseType().equals("mariadb") ? "INSERT INTO lands (\n    owner_uuid, land_name, world_name,\n    min_x, min_y, min_z, max_x, max_y, max_z,\n    level, co_owners, home_x, home_y, home_z, home_world, visits_open\n) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\nON DUPLICATE KEY UPDATE\n    land_name = VALUES(land_name),\n    level = VALUES(level),\n    co_owners = VALUES(co_owners),\n    home_x = VALUES(home_x),\n    home_y = VALUES(home_y),\n    home_z = VALUES(home_z),\n    home_world = VALUES(home_world),\n    visits_open = VALUES(visits_open),\n    updated_at = CURRENT_TIMESTAMP\n" : "INSERT OR REPLACE INTO lands (\n    owner_uuid, land_name, world_name,\n    min_x, min_y, min_z, max_x, max_y, max_z,\n    level, co_owners, home_x, home_y, home_z, home_world, visits_open\n) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, land.ownerId().toString());
                stmt.setString(2, land.name());
                stmt.setString(3, land.cuboid().world().getName());
                stmt.setDouble(4, land.cuboid().minX());
                stmt.setDouble(5, land.cuboid().minY());
                stmt.setDouble(6, land.cuboid().minZ());
                stmt.setDouble(7, land.cuboid().maxX());
                stmt.setDouble(8, land.cuboid().maxY());
                stmt.setDouble(9, land.cuboid().maxZ());
                stmt.setInt(10, land.level());
                stmt.setString(11, this.serializeCoOwners(land.coOwners()));
                if (land.home() != null) {
                    stmt.setDouble(12, land.home().getX());
                    stmt.setDouble(13, land.home().getY());
                    stmt.setDouble(14, land.home().getZ());
                    stmt.setString(15, land.home().getWorld().getName());
                } else {
                    stmt.setNull(12, 8);
                    stmt.setNull(13, 8);
                    stmt.setNull(14, 8);
                    stmt.setNull(15, 12);
                }
                stmt.setBoolean(16, land.visitsOpen());
                stmt.executeUpdate();
                PluginLogger.debug("Saved land for owner {}", land.ownerId());
                Void void_ = null;
                return void_;
            }
        });
    }

    public CompletableFuture<Optional<Land>> loadLand(@NotNull UUID ownerId) {
        return this.databaseManager.executeAsync(conn -> {
            String sql = "SELECT * FROM lands WHERE owner_uuid = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                Optional optional;
                block16: {
                    ResultSet rs;
                    block14: {
                        Optional<Land> optional2;
                        block15: {
                            stmt.setString(1, ownerId.toString());
                            rs = stmt.executeQuery();
                            try {
                                if (!rs.next()) break block14;
                                optional2 = Optional.of(this.parseLand(rs));
                                if (rs == null) break block15;
                            }
                            catch (Throwable t$) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable x2) {
                                        t$.addSuppressed(x2);
                                    }
                                }
                                throw t$;
                            }
                            rs.close();
                        }
                        return optional2;
                    }
                    optional = Optional.empty();
                    if (rs == null) break block16;
                    rs.close();
                }
                return optional;
            }
        });
    }

    public CompletableFuture<List<Land>> loadAllLands() {
        return this.databaseManager.executeAsync(conn -> {
            ArrayList<Land> lands = new ArrayList<Land>();
            String sql = "SELECT * FROM lands";
            try (Statement stmt = conn.createStatement();
                 ResultSet rs = stmt.executeQuery(sql);){
                while (rs.next()) {
                    try {
                        lands.add(this.parseLand(rs));
                    }
                    catch (Exception e) {
                        PluginLogger.error("Failed to parse land from database", e);
                    }
                }
            }
            PluginLogger.info("Loaded {} lands from database", lands.size());
            return lands;
        });
    }

    public CompletableFuture<Boolean> deleteLand(@NotNull UUID ownerId) {
        return this.databaseManager.executeAsync(conn -> {
            String sql = "DELETE FROM lands WHERE owner_uuid = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, ownerId.toString());
                int affected = stmt.executeUpdate();
                PluginLogger.debug("Deleted land for owner {}, rows affected: {}", ownerId, affected);
                Boolean bl = affected > 0;
                return bl;
            }
        });
    }

    public CompletableFuture<Void> updateLevel(@NotNull UUID ownerId, int newLevel) {
        return this.databaseManager.executeAsync(conn -> {
            String sql = "UPDATE lands SET level = ?, updated_at = CURRENT_TIMESTAMP WHERE owner_uuid = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setInt(1, newLevel);
                stmt.setString(2, ownerId.toString());
                stmt.executeUpdate();
                Void void_ = null;
                return void_;
            }
        });
    }

    public CompletableFuture<Void> updateCoOwners(@NotNull UUID ownerId, @NotNull Set<UUID> coOwners) {
        return this.databaseManager.executeAsync(conn -> {
            String sql = "UPDATE lands SET co_owners = ?, updated_at = CURRENT_TIMESTAMP WHERE owner_uuid = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, this.serializeCoOwners(coOwners));
                stmt.setString(2, ownerId.toString());
                stmt.executeUpdate();
                Void void_ = null;
                return void_;
            }
        });
    }

    public CompletableFuture<Void> updateHome(@NotNull UUID ownerId, @Nullable Location home) {
        return this.databaseManager.executeAsync(conn -> {
            String sql = "UPDATE lands SET home_x = ?, home_y = ?, home_z = ?, home_world = ?, updated_at = CURRENT_TIMESTAMP WHERE owner_uuid = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                if (home != null) {
                    stmt.setDouble(1, home.getX());
                    stmt.setDouble(2, home.getY());
                    stmt.setDouble(3, home.getZ());
                    stmt.setString(4, home.getWorld().getName());
                } else {
                    stmt.setNull(1, 8);
                    stmt.setNull(2, 8);
                    stmt.setNull(3, 8);
                    stmt.setNull(4, 12);
                }
                stmt.setString(5, ownerId.toString());
                stmt.executeUpdate();
                Void void_ = null;
                return void_;
            }
        });
    }

    public CompletableFuture<Void> updateVisitsOpen(@NotNull UUID ownerId, boolean visitsOpen) {
        return this.databaseManager.executeAsync(conn -> {
            String sql = "UPDATE lands SET visits_open = ?, updated_at = CURRENT_TIMESTAMP WHERE owner_uuid = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setBoolean(1, visitsOpen);
                stmt.setString(2, ownerId.toString());
                stmt.executeUpdate();
                Void void_ = null;
                return void_;
            }
        });
    }

    private Land parseLand(@NotNull ResultSet rs) throws SQLException {
        UUID ownerId = UUID.fromString(rs.getString("owner_uuid"));
        String name = rs.getString("land_name");
        String worldName = rs.getString("world_name");
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            throw new IllegalStateException("World not found: " + worldName);
        }
        Cuboid cuboid = new Cuboid(world, rs.getDouble("min_x"), rs.getDouble("min_y"), rs.getDouble("min_z"), rs.getDouble("max_x"), rs.getDouble("max_y"), rs.getDouble("max_z"));
        int level = rs.getInt("level");
        Set<UUID> coOwners = this.deserializeCoOwners(rs.getString("co_owners"));
        Location home = null;
        double homeX = rs.getDouble("home_x");
        if (!rs.wasNull()) {
            double homeY = rs.getDouble("home_y");
            double homeZ = rs.getDouble("home_z");
            String homeWorldName = rs.getString("home_world");
            World homeWorld = Bukkit.getWorld((String)homeWorldName);
            if (homeWorld != null) {
                home = new Location(homeWorld, homeX, homeY, homeZ);
            }
        }
        boolean visitsOpen = rs.getBoolean("visits_open");
        return new Land(ownerId, name, cuboid, level, coOwners, home, visitsOpen);
    }

    private String serializeCoOwners(@NotNull Set<UUID> coOwners) {
        if (coOwners.isEmpty()) {
            return "";
        }
        return coOwners.stream().map(UUID::toString).collect(Collectors.joining(","));
    }

    private Set<UUID> deserializeCoOwners(@Nullable String coOwnersStr) {
        if (coOwnersStr == null || coOwnersStr.isBlank()) {
            return new HashSet<UUID>();
        }
        return Arrays.stream(coOwnersStr.split(",")).map(String::trim).filter(s2 -> !s2.isEmpty()).map(UUID::fromString).collect(Collectors.toSet());
    }
}

