/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.commands;

import com.skynex.mylands.config.Messages;
import com.skynex.mylands.gui.GradesMenuGui;
import com.skynex.mylands.manager.LandManager;
import com.skynex.mylands.model.Grade;
import com.skynex.mylands.model.Land;
import com.skynex.mylands.model.LandPermission;
import com.skynex.mylands.service.GradeService;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class GradeSubCommand {
    private final LandManager landManager;
    private final GradeService gradeService;
    private final Messages messages;

    public GradeSubCommand(@NotNull LandManager landManager, @NotNull GradeService gradeService) {
        this.landManager = landManager;
        this.gradeService = gradeService;
        this.messages = landManager.getMessages();
    }

    public boolean handle(@NotNull Player player, @NotNull String[] args) {
        String subCommand;
        if (args.length < 2) {
            this.sendHelp(player);
            return true;
        }
        return switch (subCommand = args[1].toLowerCase()) {
            case "list" -> this.handleList(player);
            case "menu", "gui" -> this.handleMenu(player);
            case "create" -> this.handleCreate(player, args);
            case "delete" -> this.handleDelete(player, args);
            case "rename" -> this.handleRename(player, args);
            case "color" -> this.handleColor(player, args);
            case "priority" -> this.handlePriority(player, args);
            case "assign" -> this.handleAssign(player, args);
            case "info" -> this.handleInfo(player, args);
            default -> {
                this.sendHelp(player);
                yield true;
            }
        };
    }

    private boolean handleList(@NotNull Player player) {
        this.landManager.getLand(player.getUniqueId()).thenAccept(landOpt -> {
            if (landOpt.isEmpty()) {
                player.sendMessage(this.messages.noFarm());
                return;
            }
            Land land = (Land)landOpt.get();
            List<Grade> grades = this.gradeService.getGrades(land.ownerId());
            player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            player.sendMessage("\u00a76\u00a7lLand Grades");
            player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            if (grades.isEmpty()) {
                player.sendMessage("\u00a77No grades found. Use \u00a7e/lands grade create \u00a77to create one.");
            } else {
                for (Grade grade : grades) {
                    player.sendMessage("\u00a78\u25aa " + grade.getColoredName() + " \u00a77(Priority: \u00a7e" + grade.priority() + "\u00a77, Perms: \u00a7e" + grade.permissions().size() + "\u00a77)");
                }
            }
            player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        });
        return true;
    }

    private boolean handleMenu(@NotNull Player player) {
        this.landManager.getLand(player.getUniqueId()).thenAccept(landOpt -> {
            if (landOpt.isEmpty()) {
                player.sendMessage(this.messages.noFarm());
                return;
            }
            Land land = (Land)landOpt.get();
            this.landManager.getGuiManager().openGui(player, new GradesMenuGui(this.landManager.getGuiManager(), land, this.gradeService));
        });
        return true;
    }

    private boolean handleCreate(@NotNull Player player, @NotNull String[] args) {
        if (args.length < 3) {
            player.sendMessage("\u00a7cUsage: /lands grade create <name>");
            return true;
        }
        String gradeName = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        this.landManager.getLand(player.getUniqueId()).thenAccept(landOpt -> {
            if (landOpt.isEmpty()) {
                player.sendMessage(this.messages.noFarm());
                return;
            }
            Land land = (Land)landOpt.get();
            String gradeId = gradeName.toLowerCase().replace(" ", "_");
            Grade newGrade = new Grade(gradeId, land.ownerId(), gradeName, "\u00a77", "NAME_TAG", 3, new HashSet<LandPermission>(), false);
            if (this.gradeService.createGrade(newGrade)) {
                player.sendMessage("\u00a7a\u00a7l\u2714 Grade \u00a7f" + gradeName + " \u00a7acreated!");
                player.sendMessage("\u00a77Use \u00a7e/lands grade menu \u00a77to edit permissions.");
            } else {
                player.sendMessage("\u00a7c\u00a7l\u2716 Failed to create grade! (Max grades reached or grade already exists)");
            }
        });
        return true;
    }

    private boolean handleDelete(@NotNull Player player, @NotNull String[] args) {
        if (args.length < 3) {
            player.sendMessage("\u00a7cUsage: /lands grade delete <gradeId>");
            return true;
        }
        String gradeId = args[2].toLowerCase();
        this.landManager.getLand(player.getUniqueId()).thenAccept(landOpt -> {
            if (landOpt.isEmpty()) {
                player.sendMessage(this.messages.noFarm());
                return;
            }
            Land land = (Land)landOpt.get();
            if (this.gradeService.deleteGrade(land.ownerId(), gradeId)) {
                player.sendMessage("\u00a7a\u00a7l\u2714 Grade deleted!");
            } else {
                player.sendMessage("\u00a7c\u00a7l\u2716 Failed to delete grade! (Grade not found or is default)");
            }
        });
        return true;
    }

    private boolean handleRename(@NotNull Player player, @NotNull String[] args) {
        if (args.length < 4) {
            player.sendMessage("\u00a7cUsage: /lands grade rename <gradeId> <newName>");
            return true;
        }
        String gradeId = args[2].toLowerCase();
        String newName = String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length));
        this.landManager.getLand(player.getUniqueId()).thenAccept(landOpt -> {
            if (landOpt.isEmpty()) {
                player.sendMessage(this.messages.noFarm());
                return;
            }
            Land land = (Land)landOpt.get();
            Grade grade = this.gradeService.getGrade(land.ownerId(), gradeId);
            if (grade == null) {
                player.sendMessage("\u00a7c\u00a7l\u2716 Grade not found!");
                return;
            }
            Grade updatedGrade = new Grade(grade.id(), grade.landOwnerId(), newName, grade.color(), grade.icon(), grade.priority(), grade.permissions(), grade.isDefault());
            if (this.gradeService.updateGrade(updatedGrade)) {
                player.sendMessage("\u00a7a\u00a7l\u2714 Grade renamed to \u00a7f" + newName);
            } else {
                player.sendMessage("\u00a7c\u00a7l\u2716 Failed to rename grade!");
            }
        });
        return true;
    }

    private boolean handleColor(@NotNull Player player, @NotNull String[] args) {
        if (args.length < 4) {
            player.sendMessage("\u00a7cUsage: /lands grade color <gradeId> <color>");
            player.sendMessage("\u00a77Colors: \u00a700 \u00a711 \u00a722 \u00a733 \u00a744 \u00a755 \u00a766 \u00a777 \u00a788 \u00a799 \u00a7aa \u00a7bb \u00a7cc \u00a7dd \u00a7ee \u00a7ff");
            return true;
        }
        String gradeId = args[2].toLowerCase();
        Object color = args[3];
        if (!((String)color).startsWith("\u00a7")) {
            color = "\u00a7" + (String)color;
        }
        String finalColor = color;
        this.landManager.getLand(player.getUniqueId()).thenAccept(landOpt -> {
            if (landOpt.isEmpty()) {
                player.sendMessage(this.messages.noFarm());
                return;
            }
            Land land = (Land)landOpt.get();
            Grade grade = this.gradeService.getGrade(land.ownerId(), gradeId);
            if (grade == null) {
                player.sendMessage("\u00a7c\u00a7l\u2716 Grade not found!");
                return;
            }
            Grade updatedGrade = new Grade(grade.id(), grade.landOwnerId(), grade.name(), finalColor, grade.icon(), grade.priority(), grade.permissions(), grade.isDefault());
            if (this.gradeService.updateGrade(updatedGrade)) {
                player.sendMessage("\u00a7a\u00a7l\u2714 Grade color updated to " + finalColor + grade.name());
            } else {
                player.sendMessage("\u00a7c\u00a7l\u2716 Failed to update color!");
            }
        });
        return true;
    }

    private boolean handlePriority(@NotNull Player player, @NotNull String[] args) {
        int priority;
        if (args.length < 4) {
            player.sendMessage("\u00a7cUsage: /lands grade priority <gradeId> <1-10>");
            return true;
        }
        String gradeId = args[2].toLowerCase();
        try {
            priority = Integer.parseInt(args[3]);
            if (priority < 1 || priority > 10) {
                player.sendMessage("\u00a7c\u00a7l\u2716 Priority must be between 1 and 10!");
                return true;
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage("\u00a7c\u00a7l\u2716 Invalid priority number!");
            return true;
        }
        this.landManager.getLand(player.getUniqueId()).thenAccept(landOpt -> {
            if (landOpt.isEmpty()) {
                player.sendMessage(this.messages.noFarm());
                return;
            }
            Land land = (Land)landOpt.get();
            Grade grade = this.gradeService.getGrade(land.ownerId(), gradeId);
            if (grade == null) {
                player.sendMessage("\u00a7c\u00a7l\u2716 Grade not found!");
                return;
            }
            Grade updatedGrade = new Grade(grade.id(), grade.landOwnerId(), grade.name(), grade.color(), grade.icon(), priority, grade.permissions(), grade.isDefault());
            if (this.gradeService.updateGrade(updatedGrade)) {
                player.sendMessage("\u00a7a\u00a7l\u2714 Grade priority updated to \u00a7e" + priority);
            } else {
                player.sendMessage("\u00a7c\u00a7l\u2716 Failed to update priority!");
            }
        });
        return true;
    }

    private boolean handleAssign(@NotNull Player player, @NotNull String[] args) {
        if (args.length < 4) {
            player.sendMessage("\u00a7cUsage: /lands grade assign <player> <gradeId>");
            return true;
        }
        String targetName = args[2];
        String gradeId = args[3].toLowerCase();
        Player targetPlayer = Bukkit.getPlayer((String)targetName);
        if (targetPlayer == null) {
            player.sendMessage("\u00a7c\u00a7l\u2716 Player not found or not online!");
            return true;
        }
        this.landManager.getLand(player.getUniqueId()).thenAccept(landOpt -> {
            if (landOpt.isEmpty()) {
                player.sendMessage(this.messages.noFarm());
                return;
            }
            Land land = (Land)landOpt.get();
            Grade grade = this.gradeService.getGrade(land.ownerId(), gradeId);
            if (grade == null) {
                player.sendMessage("\u00a7c\u00a7l\u2716 Grade not found!");
                return;
            }
            if (this.gradeService.assignGrade(land.ownerId(), targetPlayer.getUniqueId(), gradeId)) {
                player.sendMessage("\u00a7a\u00a7l\u2714 Assigned " + grade.getColoredName() + " \u00a7ato \u00a7f" + targetPlayer.getName());
            } else {
                player.sendMessage("\u00a7c\u00a7l\u2716 Failed to assign grade!");
            }
        });
        return true;
    }

    private boolean handleInfo(@NotNull Player player, @NotNull String[] args) {
        if (args.length < 3) {
            player.sendMessage("\u00a7cUsage: /lands grade info <gradeId>");
            return true;
        }
        String gradeId = args[2].toLowerCase();
        this.landManager.getLand(player.getUniqueId()).thenAccept(landOpt -> {
            if (landOpt.isEmpty()) {
                player.sendMessage(this.messages.noFarm());
                return;
            }
            Land land = (Land)landOpt.get();
            Grade grade = this.gradeService.getGrade(land.ownerId(), gradeId);
            if (grade == null) {
                player.sendMessage("\u00a7c\u00a7l\u2716 Grade not found!");
                return;
            }
            player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            player.sendMessage("\u00a76\u00a7lGrade Info: " + grade.getColoredName());
            player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            player.sendMessage("\u00a77ID: \u00a7e" + grade.id());
            player.sendMessage("\u00a77Priority: \u00a7e" + grade.priority());
            player.sendMessage("\u00a77Default: " + (grade.isDefault() ? "\u00a7aYes" : "\u00a7cNo"));
            player.sendMessage("\u00a77Permissions: \u00a7e" + grade.permissions().size());
            player.sendMessage("");
            player.sendMessage("\u00a76Permissions:");
            for (LandPermission perm : grade.permissions()) {
                player.sendMessage("  \u00a78\u25aa " + perm.getColoredName());
            }
            player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        });
        return true;
    }

    private void sendHelp(@NotNull Player player) {
        player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        player.sendMessage("\u00a76\u00a7lGrade Commands");
        player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        player.sendMessage("\u00a7e/lands grade menu \u00a77- Open grades GUI");
        player.sendMessage("\u00a7e/lands grade list \u00a77- List all grades");
        player.sendMessage("\u00a7e/lands grade create <name> \u00a77- Create a grade");
        player.sendMessage("\u00a7e/lands grade delete <id> \u00a77- Delete a grade");
        player.sendMessage("\u00a7e/lands grade rename <id> <name> \u00a77- Rename a grade");
        player.sendMessage("\u00a7e/lands grade color <id> <color> \u00a77- Change color");
        player.sendMessage("\u00a7e/lands grade priority <id> <1-10> \u00a77- Set priority");
        player.sendMessage("\u00a7e/lands grade assign <player> <id> \u00a77- Assign grade");
        player.sendMessage("\u00a7e/lands grade info <id> \u00a77- View grade info");
        player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
    }

    public List<String> getTabCompletions(@NotNull String[] args) {
        if (args.length == 2) {
            return Arrays.asList("menu", "list", "create", "delete", "rename", "color", "priority", "assign", "info");
        }
        return Collections.emptyList();
    }
}

